Com.Frog.Utils.require(
    '//package/widgets/7B0161192001B97281E8EFFDD534470FE6148C8C2F28B589/assets/styles/main.css',
    '//package/widgets/7B0161192001B97281E8EFFDD534470FE6148C8C2F28B589/assets/views/main.ejs',
    '//package/widgets/7B0161192001B97281E8EFFDD534470FE6148C8C2F28B589/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.SendToEportfolio', {
    }, {
        prefs: {
            sharedFolder: {
                type: 'sharedfolder',
                defaultValue: '|'
            },
            filenameSeparator: {
                type: 'text',
                label: 'File name separator',
                defaultValue: ' - ',
                accordion: 'File name structure'
            },
            idPosition: {
                type: 'number',
                label: 'Position of student ID (e.g. 0, 1, 2 etc..)',
                defaultValue: 0,
                accordion: 'File name structure'
            },
            idType: {
                type: 'radio',
                label: 'Student ID type',
                vertical: true,
                options: {
                    'MIS ID': 'roll_number',
                    'UPN': 'pupil_number',
                    'Username': 'username',
                },
                defaultValue: 'roll_number',
                publish: [],
                accordion: 'File name structure'
            },
            ePortfolioCollectionUUID: {
                type: 'text',
                label: 'ePortfolio Collection UUID',
                defaultValue: '',
                accordion: 'UUIDs'
            },
            APIfolder: {
                type: 'text',
                label: 'Folder UUID from resources.copy',
                defaultValue: 'EDAAA0DB2002FA145040DF2AD7A6C702E0D4725CEC439D64',
                accordion: 'UUIDs'
            },
            categoryUUID: {
                type: 'text',
                label: 'User Additional Information UUID',
                defaultValue: 'CF003FF42004C73827BECFB036B6460FE76FC50C9DA7A5A2',
                accordion: 'Advanced'
            },
            rootFolder: {
                type: 'text',
                label: 'Root Folder',
                defaultValue: '5908D88C2002F393092C9F1822BA270C6ADB979CDDDE2436',
                accordion: 'Advanced'
            },
            misFilter: {
                type: 'radio',
                label: 'Student accounts to include:',
                vertical: true,
                options: {
                    'MIS only': 'mis',
                    'All students': ''
                },
                defaultValue: 'mis',
                publish: []
            }
        },
        allStudentsMIS: {},
        
        packageID: '7B0161192001B97281E8EFFDD534470FE6148C8C2F28B589',

        init: function() {},

        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            this.element.find('.send').hide();
            this.element.find('.waiting').hide();
            this.element.find('.loading').hide();
            this.element.find('.status_title').hide();
            var sendButton = 0;
            if (this.prefs.sharedFolder.value !== '|') {
                this.element.find('.no_folder').hide();
                sendButton += 1;
            }
            if (this.prefs.ePortfolioCollectionUUID.value !== '') {
                this.element.find('.no_eportfolio').hide();
                sendButton += 1;
            }
            if (sendButton === 2) {
                this.getAllStudents();
            }
        },
        
        getAllStudents: function() {
            var self = this;
            self.element.find('.loading').show();
            self.element.find('.waiting').show();
            
            var params = {
                direction: 'asc',
                group_types: 'registration|year',
                profile: 'profile-student',
                sortBy: 'surname'
            };
            if (self.prefs.misFilter.value == 'mis') {
                params.mis = 'mis';
            }        
            
            Frog.Model.api('users.getSummary', params).done(function(response) {

                var students = response.data;
                $.each(students, function(index,student) {
                    self.getMISID(student.uuid,students.length,index,student.displayname,student.username);           
                });
            }).fail(function(e) {
                // Report Error
                self.element.find('.status').append(self._('widget.placeholder.failed_student_general'));
            });

        }, 
        
        getMISID: function(uuid,total,index,name,username) {
            var self = this;
            Frog.Model.api('users.getDataInCategory', {
                user_uuid: uuid,
                uuid: self.prefs.categoryUUID.value
            }).done(function(response) {
                var misID = username;
                if (self.prefs.idType.value !== 'username') {
                    for (var i = 0; i<response.data.fields.length; i++) {
                        if (response.data.fields[i].label == self.prefs.idType.value) {
                            misID = response.data.fields[i].value;
                        }
                    }
                }
                self.allStudentsMIS[misID] = {
                    uuid: uuid,
                    username: username
                };
                
                if (index == total-1) {
                    self.element.find('.send').show();
                    self.element.find('.loading').hide();
                    self.element.find('.waiting').hide();
                    self.showGrowl.append('Ready to send files');
                }
            }).fail(function(e) {
                // Report Error
                self.element.find('.status').append($('<li></li>').text(self._('widget.placeholder.failed_student_details', [name])));
            });
        },
        
        
        '.send click': function () {
            var self = this;
            self.element.find('.status').empty();
            self.element.find('.status_title').show();
            var sharedFolderArray = this.prefs.sharedFolder.value.split('|');
                        
            Frog.Model.api('resources.getOfType', {
                authors: true,
                external_folder_id: null,
                folder: sharedFolderArray[0],
                is_local: true,
                limit: 500,
                offset: 0,
                order: {
                    site: 'name asc',
                    googledrive: ['is_folder desc','name asc']
                },
                type: 'personal',
                root_folder: this.prefs.rootFolder.value, 
                sources: ['native', 'site', 'googledrive', 'onedrivebusiness']
            }).done(function(response) {
                
                var files = response.data.resources;
                $.each(files, function(ind,file) {
                    if (file.attachment.deleted == 0) {
                        var fileNames = file.attachment.name.split('_').join(self.prefs.filenameSeparator.value).split(self.prefs.filenameSeparator.value);
                        var misID = fileNames[self.prefs.idPosition.value];
                        self.getEportfolio(misID,file.uuid,file.attachment.name);
                    }
                });
                
                
            }).fail(function(e) {
                
                self.element.find('.status').append(self._('widget.placeholder.failed_files'));
            });
            
        },
        
        getEportfolio: function(misID,fileUUID,filename) {
            var self = this;
            if (misID in self.allStudentsMIS === true) {
                Frog.Model.api('sites.getSitesByAssociation', {
                    all: true,
                    limit: 15,
                    offset: 0,
                    order: {name: 'asc'},
                    query: self.allStudentsMIS[misID].username,
                    requires: {columns: false},
                    scope: 'personal',
                    sitegroup_uuid: self.prefs.ePortfolioCollectionUUID.value,
                    type: 'recipient_eportfolios',
                    view: 'eportfolios'
                }).done(function(response) {
                    var ePortfolio = response.data[0].children[0];
                    var ePortfolioUUID = ePortfolio.uuid;
                    self.sendTo(fileUUID,filename,ePortfolioUUID,self.allStudentsMIS[misID]);
                    
                }).fail(function(e) {
                    self.element.find('.status').append($('<li></li>').text(self._('widget.placeholder.failed_eportfolio', [misID])));
                });
            }
        },
        
        sendTo: function(fileUUID,filename,eportfolio,student) {
            var self = this;
            Frog.Model.api('resources.copy', {
                description: '',
                folder: self.prefs.APIfolder.value,
                grouped_by_transaction: false,
                resource: fileUUID,
                target: [eportfolio],
                type: 'personal'
            },{
                type: 'POST'
            }).done(function(response) {
                self.element.find('.status').append($('<li></li>').text(self._('widget.placeholder.success', [filename])));
            }).fail(function(e) {
                // Report Error
                self.element.find('.status').append($('<li></li>').text(self._('widget.placeholder.failed_to_send', [filename])));
            });        
        },

        
        
        
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        },
        showGrowl: function(string) {
            var icon = 'externalapps/icon/'+this.packageID;
            Frog.Controller.prototype.growl(string,'Send to ePortfolio','app-name',{time:'5000', icon: icon});
        },

        'widget.updated': function(el, ev, data) {}
    });
});
