Com.Frog.Utils.require(
    '//package/widgets/022366172001B9898DBD5FE54860D700F04FF87C3C44A0A7/assets/styles/main.css',
    '//package/widgets/022366172001B9898DBD5FE54860D700F04FF87C3C44A0A7/assets/views/main.ejs',
    '//package/widgets/022366172001B9898DBD5FE54860D700F04FF87C3C44A0A7/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.ActivityTimer', {
    }, {
        prefs: {},

        packageID: '022366172001B9898DBD5FE54860D700F04FF87C3C44A0A7',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            var currentTimeCount=180,
                initialTimeCount=currentTimeCount,
                nogo="no",
                minutes,
                seconds,
                percentRemaining = 100,
                pase = this.element.find( ".pause" ),
                strt = this.element.find( ".start" ),
                stp = this.element.find( ".stop" ),
                countDownNumbers = this.element.find('.countDownNumbers'),
                timerBar = this.element.find('.timerBar'),
                preset  = this.element.find('.preset'),
                manual  = this.element.find('.manual'),
                presetTable  = this.element.find('.presetTable'),
                timeString,
                baseURL=Frog.Utilities.getBaseUrl(),

            // Convert the current milisecond count to minutes and seconds, including leading zeros
                timeDisplay = function() {
                    minutes=parseInt(currentTimeCount/60);
                    seconds=(currentTimeCount/60)-minutes;
                    seconds=currentTimeCount-minutes*60;
                    if (seconds<10) {
                        if (seconds<1) {
                            seconds="00";
                        } else {
                            seconds = "0"+seconds;
                        }
                    }
                    timeString = minutes+":"+seconds;
                    countDownNumbers.html(timeString);
                };
            timeDisplay();

            // Hide the pause (pase) and stop (stp) buttons.
            pase.hide();
            stp.hide();
            // When the timer starts, variable nogo is used for pausing.  Hide the start (strt) button, show the pause button, hide the table containing timing options.  Showe the stop button.
            strt.on('click', function() {
                if (nogo=="no") {
                    nogo="yes";
                    $( this ).hide();
                    pase.show();
                    presetTable.hide();
                    countDownNumbers.css('color','#0071b9');
                    timerBar.css('background','#0071b9');
                }
                stp.show();
            });
            // On pausing, nogo is set to no, this halts the countdown, but does not reset it.
            pase.on('click', function() {
                    nogo="no";
                    $( this ).hide();
                    strt.show();
            });
            // On changing the time via the preset menu, update the countdown display.
            preset.on('change', function() {
                if (preset.filter(':checked').val()!=="manual") {
                    currentTimeCount=preset.filter(':checked').val()*60;
                    initialTimeCount=currentTimeCount;
                    timeDisplay();
                }
            });
            // On changing the value of the text input, update the countdown display instantly
            manual.bind('keyup mouseup', function () {
                if (preset.filter(':checked').val()=="manual") {
                    currentTimeCount=manual.val()*60;
                    initialTimeCount=currentTimeCount;
                    timeDisplay();
                }
            });
            // On clicking the stop button, reset the timer.
            stp.on('click', function() {
                    nogo="no";
                    stp.hide();
                	pase.hide();
                    strt.show();
                    currentTimeCount=initialTimeCount;
                    timeDisplay();
                    presetTable.show();
               	    timerBar.width('100%');
                    timerBar.css('background','#0071b9');
            });
            // The countdown function.  Only runs when nogo is yes.
            this.timedInterval = setInterval(function(){
                if (nogo=="yes") {
                    currentTimeCount=currentTimeCount-1;
                    timeDisplay();
                    percentRemaining=100*currentTimeCount/initialTimeCount;
                    // Reduce the width of the timerBar
                    timerBar.width(percentRemaining+'%');
                    // Change the colour of the countdown to amber then red.
                    if (percentRemaining<20) {
                        if (percentRemaining<5) {
                            countDownNumbers.css('color','#FF0000');
                            timerBar.css('background','#FF0000');
                        } else {
                            countDownNumbers.css('color','#FFC200');
                            timerBar.css('background','#FFC200');
                        }
                    }
                    // Once the time has run out, play the alert mp3
                    if (currentTimeCount<1) {
                        var sound = $('<embed autoplay="true" height="0" width="0" />');
                        sound.attr('src', baseURL+'/app/package/widgets/022366172001B9898DBD5FE54860D700F04FF87C3C44A0A7/assets/rf_alert.mp3');
                        $('body').append(sound);
                    }
                    // Once the timer has finished, reset everything.
                    if (currentTimeCount<=0) {
                        strt.show();
                        pase.hide();
                        stp.hide();
                        presetTable.show();
                        nogo="no";
                        currentTimeCount=initialTimeCount;
                    }
                }
                }.bind(this), 1000);
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        }
    });
});
