Com.Frog.Utils.require(
    '//package/widgets/3A1450EC2001BD341C057F2B7B16EB095D83735CE2BDCD23/assets/styles/main.css',
    '//package/widgets/3A1450EC2001BD341C057F2B7B16EB095D83735CE2BDCD23/assets/views/main.ejs',
    '//package/widgets/3A1450EC2001BD341C057F2B7B16EB095D83735CE2BDCD23/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.DiamondNine', {
    }, {
        prefs: {
            'textcolour': {
                type: 'colourpicker',
                label: 'Text Colour',
                defaultValue: '#000000'
            },
            'textsize': {
                type: 'number',
                label: 'Text Size',
                showUnits: "Pt",
                defaultValue: 11
            },
            'cardBG': {
                type: 'colourpicker',
                label: 'Card Colour',
                defaultValue: '#ffa3a3'
            },
            'cardborder': {
                type: 'colourpicker',
                label: 'Card Border',
                defaultValue: '#FF0000'
            },
            'card1': {
                type: 'text',
                label: 'Card 1',
                defaultValue: ''
           },
            'card2': {
                type: 'text',
                label: 'Card 2',
                defaultValue: ''
           },
            'card3': {
                type: 'text',
                label: 'Card 3',
                defaultValue: ''
           },    
            'card4': {
                type: 'text',
                label: 'Card 4',
                defaultValue: ''
           },   
            'card5': {
                type: 'text',
                label: 'Card 5',
                defaultValue: ''
           },
           'card6': {
                type: 'text',
                label: 'Card 6',
                defaultValue: ''
           },            
           'card7': {
                type: 'text',
                label: 'Card 7',
                defaultValue: ''
           },   
           'card8': {
                type: 'text',
                label: 'Card 8',
                defaultValue: ''
           },   
           'card9': {
                type: 'text',
                label: 'Card 9',
                defaultValue: ''
           }               
        },

        packageID: '3A1450EC2001BD341C057F2B7B16EB095D83735CE2BDCD23',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            this.renderInEdit();
            this.element.find('.input').hide();
            this.element.find('.instructions').hide();
            
            this.element.find('.card1').text(this.prefs.card1.value);
            this.element.find('.card2').text(this.prefs.card2.value);
            this.element.find('.card3').text(this.prefs.card3.value);
            this.element.find('.card4').text(this.prefs.card4.value);
            this.element.find('.card5').text(this.prefs.card5.value);
            this.element.find('.card6').text(this.prefs.card6.value);
            this.element.find('.card7').text(this.prefs.card7.value);
            this.element.find('.card8').text(this.prefs.card8.value);
            this.element.find('.card9').text(this.prefs.card9.value);
            
            this.element.find('.card').draggable({ revert: "invalid" },{});        
            this.element.find('.target').droppable();
            this.element.find('.starting').droppable();

        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            this.element.find('.instructions').show();
			this.renderInEdit();
            
            this.element.find('.card1text').val(this.prefs.card1.value);
            this.element.find('.card2text').val(this.prefs.card2.value);
            this.element.find('.card3text').val(this.prefs.card3.value);
            this.element.find('.card4text').val(this.prefs.card4.value);
            this.element.find('.card5text').val(this.prefs.card5.value);
            this.element.find('.card6text').val(this.prefs.card6.value);
            this.element.find('.card7text').val(this.prefs.card7.value);
            this.element.find('.card8text').val(this.prefs.card8.value);
            this.element.find('.card9text').val(this.prefs.card9.value);

        },

        '.edit .card1text keyup': jQuery.debounce(function(el, ev) {
            this.prefs.card1.value = el.val();
        }, 500),
        '.edit .card2text keyup': jQuery.debounce(function(el, ev) {
            this.prefs.card2.value = el.val();
        }, 500),       
        '.edit .card3text keyup': jQuery.debounce(function(el, ev) {
            this.prefs.card3.value = el.val();
        }, 500),  
        '.edit .card4text keyup': jQuery.debounce(function(el, ev) {
            this.prefs.card4.value = el.val();
        }, 500),   
        '.edit .card5text keyup': jQuery.debounce(function(el, ev) {
            this.prefs.card5.value = el.val();
        }, 500),
        '.edit .card6text keyup': jQuery.debounce(function(el, ev) {
            this.prefs.card6.value = el.val();
        }, 500),       
        '.edit .card7text keyup': jQuery.debounce(function(el, ev) {
            this.prefs.card7.value = el.val();
        }, 500),  
        '.edit .card8text keyup': jQuery.debounce(function(el, ev) {
            this.prefs.card8.value = el.val();
        }, 500),           
        '.edit .card9text keyup': jQuery.debounce(function(el, ev) {
            this.prefs.card9.value = el.val();
        }, 500),         
        'widget.save': function(el, ev, data) {      
            this.renderInEdit();
        },     
         renderInEdit : function() {
             
            this.element.find('.card').css('color',this.prefs.textcolour.value);
            this.element.find('.input').css('color',this.prefs.textcolour.value);
            this.element.find('.card').css('font-size',this.prefs.textsize.value+'pt');
            this.element.find('.input').css('font-size',this.prefs.textsize.value+'pt');
            this.element.find('.card').css('background',this.prefs.cardBG.value);
            this.element.find('.card').css('border-color',this.prefs.cardborder.value);
            this.element.find('.input').css('background',this.prefs.cardBG.value);


         },
        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {
            
        }
    });
});
