Com.Frog.Utils.require(
    '//package/widgets/404D4FB32001B95C1FD83F608F2D2B0692B6015C697C8650/assets/styles/main.css',
    '//package/widgets/404D4FB32001B95C1FD83F608F2D2B0692B6015C697C8650/assets/views/main.ejs',
    '//package/widgets/404D4FB32001B95C1FD83F608F2D2B0692B6015C697C8650/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.Dice', {
    }, {
        prefs: {
            ttle: {
                type: 'text',
                label: 'Label',
                defaultValue: 'Click the dice to roll'
            },
            diecolour: {
                type: 'colourpicker',
                label: 'Die colour',
                defaultValue: '#0071b9'
            },
            dicetype: {
                type: 'radio',
                label: "Select View Mode",
                vertical: true,
                options: {
                    'Number / Dots': 'main.ejs',
                    '6 Ws': 'whatwords.ejs',
                    'Can, is, would...': 'canifwould.ejs',
                    'Custom': 'custom.ejs',
                },
                defaultValue: "main.ejs",
                publish: []
            },
            custom: {
                type: 'textarea',
                label: 'Custom words (comma separated) - use short words',
                defaultValue: '',
                placeholder: 'Big, Small, Large, Tall, Tiny, Average'
            }
        },
        edit_mode : false,
        packageID: '404D4FB32001B95C1FD83F608F2D2B0692B6015C697C8650',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view( this.prefs.dicetype.value )
            );
            this.edit_mode = false;
            this.renderInEdit();
        },
        '.myCube click': function(el, ev) {
            if (this.edit_mode === false) {
                var min = 1,
                    max = 24,
                    xRand = this.getRandom(max, min),
                    yRand = this.getRandom(max, min),
                    cube = this.element.find('.myCube')[0];
            
                cube.style.webkitTransform = 'rotateX('+xRand+'deg) rotateY('+yRand+'deg)';
                cube.style.transform = 'rotateX('+xRand+'deg) rotateY('+yRand+'deg)';
            }
        },
        getRandom : function(max, min) {
            return (Math.floor(Math.random() * (max-min)) + min) * 90;
        },
        setCustom : function() {
            var customWords = ['','','','','',''],
                customPref = this.prefs.custom.value.split(',');
            
            for (var i = 0; i < customPref.length; i++ ) {
                customWords[i] = customPref[i];
            }
            this.element.find('.front').html(customWords[0]);
            this.element.find('.back').html(customWords[1]);
            this.element.find('.right').html(customWords[2]);
            this.element.find('.left').html(customWords[3]);
            this.element.find('.top').html(customWords[4]);
            this.element.find('.bottom').html(customWords[5]);
        },
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view( this.prefs.dicetype.value )
            );
            this.edit_mode = true;
            this.renderInEdit();
        },
        
        'widget.save': function(el, ev, data) {
            this.element.html(
                this.view( this.prefs.dicetype.value )
            );
            this.edit_mode = true;
            this.renderInEdit();
        },
        renderInEdit : function() {  
            this.element.find('h2').text(this.prefs.ttle.value);
            if (this.prefs.dicetype.value == 'custom.ejs') {
                this.setCustom();
            }
            this.element.find('#cube div').css('background',this.hexToRGB(this.prefs.diecolour.value));
            this.element.find('#cube div').css('border','2px solid '+this.prefs.diecolour.value);
        },
        
        hexToRGB : function(hex) {
            var r = parseInt(hex.slice(1, 3), 16),
                g = parseInt(hex.slice(3, 5), 16),
                b = parseInt(hex.slice(5, 7), 16);
           return "rgba(" + r + ", " + g + ", " + b + ", 0.9)";
        },
        
        
        'widget.updated': function(el, ev, data) {}
    });
});
