Com.Frog.Utils.require(
    '//package/widgets/4E287F9B2001BFA9DF60AF1B0E3D8C07962E48AC898C89D7/assets/styles/main.css',
    '//package/widgets/4E287F9B2001BFA9DF60AF1B0E3D8C07962E48AC898C89D7/assets/views/main.ejs',
    '//package/widgets/4E287F9B2001BFA9DF60AF1B0E3D8C07962E48AC898C89D7/assets/models/resource.js',
    '//package/widgets/4E287F9B2001BFA9DF60AF1B0E3D8C07962E48AC898C89D7/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.eBookLink', {
    }, {
        prefs: {
            eBookUrl: {
                type: 'upload',
                label: 'eBook File (ePub)',
                defaultValue: '',
                showDiscover: false
            },
            eBookTitle: {
                type: 'text',
                label: 'Title',
                defaultValue: ''
            },
            author: {
                type: 'text',
                label: 'Description',
                defaultValue: 'Read on Frog'
            },
            showDownload: {
                type: 'boolean',
                label: 'Show download link',
                defaultValue: true
            },
            mimeType: {
                type: 'hidden',
                label: 'Mime Type',
                defaultValue: ''
            },
            extension: {
                type: 'hidden',
                label: 'Ext',
                defaultValue: ''
            },
            fileSize: {
                type: 'hidden',
                label: 'File Size',
                defaultValue: ''
            }
        },
        packageID: '4E287F9B2001BFA9DF60AF1B0E3D8C07962E48AC898C89D7',

        file: null,
        resource: null,
        init: function(options) {
            this.resource = new Widget.Models.Resource(this.prefs);
        },


        '.ebook_lozenge click': function () {
            var self = this,
                data = { name: 'ebookreader', resource: self.resource };
            if (self.editMode == false) {
                self.element.trigger('os.internal.launchapp', { data: data });
            }
        },
        
        '.dl_button click': function(el, ev) {
            var self = this;
            if (self.editMode == false) {
                ev.stopPropagation();
                if (self.prefs.eBookUrl.value !== '') {
                    Frog.Utilities.download(
                        self.prefs.eBookUrl.value + (true ? '?mode=download' : ''),true
                    );
                }
            }
        },
        
        refreshResource: function() {
            this.resource = null;
            
            var self = this,
                uuid = self.prefs.eBookUrl.value.replace('file/asset/', '').slice(0, -1),
                url = self.prefs.eBookUrl.value.slice(0,-1),
                baseUrl = Frog.Utilities.getBaseUrl() + '/app/';

            self.resource = new Widget.Models.Resource({
                url: self.prefs.eBookUrl.value,
                external_url: baseUrl + url,
                src: baseUrl + url,
                attachment: {
                    file: {
                        mime: { 
                            ext: '.epub' // the returned mime type is not accepted by ebookreader
                        },
                        url: baseUrl + url
                    },
                    name: 'eBook'
                },
                uuid: uuid,
                fileExt: self.prefs.extension.value,
                mimeType: 'application/epub+zip' 
            });
            
        },

        'widget.edit': function (el, ev) {
            this.editMode = true;
            this.render();
        },

        'widget.live': function (el, ev) {
            this.editMode = false;
            this.render();
        },
        
        render : function() {
            var self = this;
            self.refreshResource();
            self.element.html( self.view( 'main.ejs' ));
            var bookTitle = self.element.find('.book_title');

            if (self.prefs.eBookUrl.value !== '') {
                bookTitle.text( self.prefs.eBookTitle.value );
            }

            if (self.prefs.eBookUrl.value !== '') {
                if ( self.prefs.eBookTitle.value == '') { // if there is not a manual title and a book has been uploaded
                    FrogOS.fdp({
                        url: 'resource/get',
                        path: '/api/fdp/1/',
                        type: 'GET',
                        data: { uuid: self.resource.uuid }
                    }).done(function(response) {
                        var fileName = response.response.attachment.name;
                        if (fileName && self.prefs.eBookTitle.value == '' ) { // do not clear label if nothing returned
                            bookTitle.text( fileName );
                            self.prefs.eBookTitle.value = fileName;
                        }
                    });
                } else {
                    bookTitle.text( self.prefs.eBookTitle.value );      
                } 
            }
        },


        'widget.save': function (el, ev) {
            var file = this.file,
                prefs = this.prefs;
            
            if (file) {
                // Update prefs using file data
                prefs.mimeType.value = file.mime.mime;
                prefs.extension.value = file.mime.ext;
                prefs.fileSize.value = file.size;               
            }

            this.prefs = prefs;
            this.refreshResource();
            this.render();
        },

        'widget.file': function (el, ev, asset) {
            this.file = asset.file;
        },

    });
});
