Com.Frog.Utils.require(
    '//package/widgets/5DE850782001B0705DB2AF01B80B0D0908DBB4CC25BEAF12/assets/styles/main.css',
    '//package/widgets/5DE850782001B0705DB2AF01B80B0D0908DBB4CC25BEAF12/assets/views/main.ejs',
    '//package/widgets/5DE850782001B0705DB2AF01B80B0D0908DBB4CC25BEAF12/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.ePortfolioUserDetails', {
    }, {
        prefs: {
            usernamePos: {
	           type: "list",
	           label: "Is the username in position 2 or 3 in the ePortfolio's title?, i.e. \nSite Title [#1] - Name [#2] - Username [#3]",
	           defaultValue: "1",
	           options: {
	               "Position 2": "1",
	               "Position 3": "2"
               }
           },
           showThumbnail: {
	           type: "boolean",
	           label: "Show recipient's picture",
	           defaultValue: true
           },
           showName: {
	           type: "boolean",
	           label: "Show recipient's name",
	           defaultValue: true
           },
           showGender: {
	           type: "boolean",
	           label: "Display recipient's sex",
	           defaultValue: false
           },
           showEmail: {
	           type: "boolean",
	           label: "Display recipient's email address (only possible if their username is part of the email address)",
	           defaultValue: false,
               accordion: "settings.advanced"
           },
           showEmailappend: {
               type: "text",
               label: "Append email domain",
               defaultValue: "",
               placeholder: "@frogeducation.com",
               accordion: 'settings.advanced'
           },
           height: {
               type: "number",
               label: "Height of picture",
               defaultValue: 200,
               showUnits: "px",
               accordion: "settings.advanced"
           },
           fontsize: {
               type: "number",
               label: "Font size",
               defaultValue: 16,
               showUnits: "px",
               accordion: "settings.advanced"
           },
           textCSS: {
               type: "text",
               label: "Additional text styling",
               defaultValue: "",
               placeholder: "Add CSS here",
               accordion: 'settings.advanced'
           },
           imgCSS: {
               type: "text",
               label: "Additional image styling",
               defaultValue: "",
               placeholder: "Add CSS here",
               accordion: 'settings.advanced'
           },
        },

        packageID: '5DE850782001B0705DB2AF01B80B0D0908DBB4CC25BEAF12',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},
        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            this.renderInEdit();
            
        },
        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            this.renderInEdit();
            this.element.find(".editInfo").show();
			this.element.find(".editInfo").text(
                "This widget uses the username within the site's title to identify the recipient and bring back their name and image.  Images can be added individually via the Users app or in bulk by contact Frog's Service Desk."
            );
        },

        'widget.save': function(el, ev, data) {
            this.renderInEdit();
        },
         renderInEdit : function() {
			var siteName = this.element.closest('.sites-site-content').data('site-name'),
    			siteNameArray = siteName.split(' - '),
    			recipientUsername = siteNameArray[this.prefs.usernamePos.value],
				siterecipient = this.element.find(".siterecipient");

            if (!recipientUsername) {
				recipientUsername = FrogOS.getUser().username;
            }

            
			Frog.Model.api('users.getSummary', {
    			search: recipientUsername,
   				direction: 'asc',
    			group_types: 'registration|year',
    			sortBy: 'surname'
			}).done(function(listResponse) {
    			var userdeets = listResponse.data[0].details;
                siterecipient.html(" ");
                if (String(this.prefs.showThumbnail.value)==true) {
                    var thumbnail;                 
                    if (!userdeets.thumbnail) {
                 		thumbnail = "users/public/images/default_no_gender.png";                 
                    } else {
                		thumbnail = userdeets.thumbnail;
                    }
                    siterecipient.append(
                        '<img style="max-width: 100%; width: auto; height: '+this.prefs.height.value+'px;  '+this.prefs.imgCSS.value+'" src="'+thumbnail+'">'
                    );
            	};
                if (String(this.prefs.showName.value)==true) {
                	siterecipient.append(
                		'<div style="font-size: '+this.prefs.fontsize.value+'px; '+this.prefs.textCSS.value+'">'+userdeets.forename+" "+userdeets.surname+'</div>'
                	)
            	};
                if (String(this.prefs.showGender.value)==true) {
                	siterecipient.append(
                		'<div style="font-size: '+this.prefs.fontsize.value+'px; '+this.prefs.textCSS.value+'">'+userdeets.gender+'</div>'
                	)
            	};
                if (String(this.prefs.showEmail.value)==true) {
                	siterecipient.append(
                		'<div style="font-size: '+this.prefs.fontsize.value+'px; '+this.prefs.textCSS.value+'"><a href="mailto:'+recipientUsername+this.prefs.showEmailappend.value+'">'+recipientUsername+this.prefs.showEmailappend.value+'</a></div>'
                	)
            	};
			}.bind(this));
        },

        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {

        }
    });
});