Com.Frog.Utils.require(
    '//package/widgets/153C4BCC2001B8E8AD144F239F3FE5003FBD2FDC3438C947/assets/styles/main.css',
    '//package/widgets/153C4BCC2001B8E8AD144F239F3FE5003FBD2FDC3438C947/assets/views/main.ejs',
    '//package/widgets/153C4BCC2001B8E8AD144F239F3FE5003FBD2FDC3438C947/widget.ejs'
).then(function() {
     var mytimer = null;
    Com.Frog.Controllers.Widget.extend('Widget.EventCountdown', {
    }, {
        prefs: {
            widget_title: {
                type: "text",
                label: "Give your event a name",
                defaultValue: "Title Placeholder"
            },
            event_date: {
                type: "text",
                label: "Enter date and time of your event in DD/MM/YYYY HH:MM (24 hour) format",
                defaultValue: ""
            },
            widget_size: {
                type: 'range',
                label: "Set the size of your widget (in %)",
                min: 50,
                max: 100,
                step: 10,
                defaultValue: 70,
                hidden: false
            },
            count_mode: {
                type: 'boolean',
                label: 'Should we count up once event is reached?',
                defaultValue: 'true',
                accordion: 'settings.advanced'
            },
            bg_colour: {
                type: 'colourpicker',
                label: 'Choose the main background colour',
                defaultValue: '#222226',
                accordion: 'Colours and Appearance'
            },
            ibg_colour: {
                type: 'colourpicker',
                label: 'Choose the secondary background colour',
                defaultValue: '#F2F2F2',
                accordion: 'Colours and Appearance'
            },
            font_colour: {
                type: 'colourpicker',
                label: 'Choose the main font colour',
                defaultValue: '#FFFFFF',
                accordion: 'Colours and Appearance'
            },
            ifont_colour: {
                type: 'colourpicker',
                label: 'Choose the secondary font colour',
                defaultValue: '#AAA',
                accordion: 'Colours and Appearance'
            }
            
        },

        packageID: '153C4BCC2001B8E8AD144F239F3FE5003FBD2FDC3438C947',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.EditUpdate();
        },
        
        EditUpdate: function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            
            this.element.find(".countdown").width(this.prefs.widget_size.value+"%");
            this.element.find(".countdown_title").text(this.prefs.widget_title.value);
            this.element.find(".countdown").css('background-color', this.prefs.bg_colour.value);
            this.element.find(".countdown").css('color', this.prefs.font_colour.value);
            this.element.find(".countdown_section").css('background-color', this.prefs.ibg_colour.value);
            this.element.find(".countdown_section").css('color', this.prefs.ifont_colour.value);
            
            var countdown = function() {
                var show_past = this.prefs.count_mode.value;
                var edate = this.prefs.event_date.value.trim();    
                var now = moment();
                var mdate = moment(edate, "DD/MM/YYYY HH:mm");
				
                if (mdate.isValid() == true) {
                    var days = mdate.diff(now, 'days');
                    mdate.subtract(days, 'day');
                    var hours = mdate.diff(now, 'hours');
                    mdate.subtract(hours, 'hour');
                    var mins = mdate.diff(now, 'minutes');
                    mdate.subtract(mins, 'minute');
                    var secs = mdate.diff(now, 'seconds');

                    if (show_past == false) {
                        if (days < 0) {
                            days = 0;
                        }
                        if (hours < 0) {
                            hours = 0;
                        }
                        if (mins < 0) {
                            mins = 0;
                        }
                        if (secs < 0) {
                            secs = 0;
                        }
                    }

                    this.element.find("span.countdown_amount:eq(0)").text(days);
                    this.element.find("span.countdown_amount:eq(1)").text(hours);
                    this.element.find("span.countdown_amount:eq(2)").text(mins);
                    this.element.find("span.countdown_amount:eq(3)").text(secs);
                    mytimer = setTimeout(countdown, 1000);
                } else {
                    this.element.find("span.countdown_amount:eq(0)").text("N/A");
                    this.element.find("span.countdown_amount:eq(1)").text("N/A");
                    this.element.find("span.countdown_amount:eq(2)").text("N/A");
                    this.element.find("span.countdown_amount:eq(3)").text("N/A");
                }
            }.bind(this);

         countdown();
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            if (mytimer != null) {
                clearTimeout(mytimer); 
                mytimer = null;
            }
            this.EditUpdate();
        },
        
        'widget.save': function(el, ev, data) {
            this.EditUpdate();
        },

        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {}
    });
});
