Com.Frog.Utils.require(
    '//package/widgets/12E907EF2001B576326E6FF148F2F906F6437E5C94D8FFF0/assets/styles/main.css',
    '//package/widgets/12E907EF2001B576326E6FF148F2F906F6437E5C94D8FFF0/assets/views/main.ejs',
    '//package/widgets/12E907EF2001B576326E6FF148F2F906F6437E5C94D8FFF0/assets/views/video_modal.ejs',
    '//package/widgets/12E907EF2001B576326E6FF148F2F906F6437E5C94D8FFF0/assets/views/file_layout.ejs',
    '//package/widgets/12E907EF2001B576326E6FF148F2F906F6437E5C94D8FFF0/assets/views/playicon.ejs',
    '//package/widgets/12E907EF2001B576326E6FF148F2F906F6437E5C94D8FFF0/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.FolderSearch', {
    }, {
        prefs: {
             "shared_folder": {
                "type": "sharedfolder",
                "defaultValue": "|"
            }
        },

        packageID: '12E907EF2001B576326E6FF148F2F906F6437E5C94D8FFF0',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            var folderID = this.prefs.shared_folder.value.split("|"),
            folderList = this.element.find('.folderList'),
            folderDisplayDiv = this.element.find('.folderDisplayDiv'),
            newSearch = $('<input type="text" class="htmlSearch input-medium search-query" class="form-control" placeholder="Search">'),
            newSearchButton = $('<input type="button" class="btn" value="Search" >'),
            newclear = $('<input type="button" class="btn" value="Clear" >');

            // default styling was getting in the way of correctly laying out the table.
            this.element.removeAttr('style');

            if (this.prefs.shared_folder.value==="|") {
                folderDisplayDiv.append('No folder specified.  Please set the top-level folder.');
            } else {
                folderDisplayDiv.before(newSearch);
                folderDisplayDiv.before(newSearchButton);
                folderDisplayDiv.before(newclear);
            }

            var searchFolder = function(folder,searchTerm) {
               Frog.Model
                    .api('resources.getOfType', {
                        sources: ["native","site"],
                        type: 'staff',
                        author: 'true',
                        root_folder: 'EDAAA0E92002F81B92C2DFCD917CAC05E532634CEE5FEBD9',
                        folder: folder,
                        filter: null,
                        exclude_templates: 'true'
                    }).done(function(listResponse) {
                        var files = listResponse.data.resources,
                            folders = listResponse.data.folders;
                        $.each(files, function(index,file) {
                            if (file.attachment.name.toLowerCase().indexOf(searchTerm)>-1) {
                                folderList.append(
                                    this.view("file_layout.ejs", {file: file})
                                ); /* End of append */
                            } /* end of searchTerm check */
                    }.bind(this)); /* end of $.each */
                   // For each folder returned in the search, search these folders
                    $.each(folders, function(index,folder) {
                      	searchFolder(folder.uuid,searchTerm);
                    });
                   // Add a modal with video player
                    $('.playvideo').unbind('click').click(function(ev) {
                        this.modal($(ev.target).data('name'),this.view('video_modal.ejs',{src:$(ev.target).data('vid')}));
                    }.bind(this));

            }.bind(this));
            }.bind(this); /* end of searchFolder function */
            // On click, run the search
            newSearchButton.on('click', function(){
                var searchTerm =  newSearch.val().toLowerCase();
                $('.folderList tr').remove();
                searchFolder(folderID[0],searchTerm);
            });
            // On click, clear the search term and results.
            newclear.click(function() {
                newSearch.val("");
                $('.folderList tr').remove();
            });
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        }
    });
});
