Com.Frog.Utils.require(
    '//package/widgets/17FF0D462001BB9182A80F526A5FB6029514B39CE16493FA/assets/styles/main.css',
    '//package/widgets/17FF0D462001BB9182A80F526A5FB6029514B39CE16493FA/assets/views/main.ejs',
    '//package/widgets/17FF0D462001BB9182A80F526A5FB6029514B39CE16493FA/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.Thermometer', {
    }, {
        prefs: {
            amount: {
                type: 'number',
                defaultValue: 0,
                label: 'Amount raised'
            },
            target: {
                type: 'number',
                defaultValue: 100,
                label: 'Target to raise'
            },
            currency: {
                type: 'text',
                defaultValue: '£',
                label: 'Currency'
            },
            title: {
                type: 'text',
                defaultValue: 'Our goal',
                label: 'What are you raising money for?'
            },
            fontsizeTitle: {
                type: "number",
                defaultValue: 14,
                label: "Title Font size (pt)",
                accordion: 'settings.advanced'
            },
            fontsizeTarget: {
                type: "number",
                defaultValue: 14,
                label: "Target value Font size (pt)",
                accordion: 'settings.advanced'
            },    
            fontsizeCurrent: {
                type: "number",
                defaultValue: 14,
                label: "Current value Font size (pt)",
                accordion: 'settings.advanced'
            },    
            css: {
                type: "text",
                defaultValue: "",
                label: "Stylesheet (for widget)",
                accordion: 'settings.advanced'
            }, 
        },

        packageID: '17FF0D462001BB9182A80F526A5FB6029514B39CE16493FA',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.renderPlaceholder();
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.renderPlaceholder();
        },
        'widget.save': function(el, ev, data) {      
            this.renderPlaceholder();
            
        },
        renderPlaceholder : function() {
            this.element.html(
                this.view('main.ejs')
            );
            var percent = 100*this.prefs.amount.value/this.prefs.target.value;
            this.element.find('.total').css('bottom',percent+'%');
           /* Animated height */
            this.element.find('.amount').animate({height: percent+'%'},3000);
            
            /* Styling options */
            this.element.find('.title').css('font-size',this.prefs.fontsizeTitle.value+'pt');
            this.element.find('.title').css('line-height',this.prefs.fontsizeTitle.value+'pt');
            this.element.find('.goal').css('font-size',this.prefs.fontsizeTarget.value+'pt');
            this.element.find('.goal').css('line-height',this.prefs.fontsizeTarget.value+'pt');
            this.element.find('.total').css('font-size',this.prefs.fontsizeCurrent.value+'pt');
        }
    });
});