Com.Frog.Utils.require(
    '//package/widgets/B9C80C792001B15095495FF4A661D20FD5C2B55C370EE299/assets/styles/main.css',
    '//package/widgets/B9C80C792001B15095495FF4A661D20FD5C2B55C370EE299/assets/views/main.ejs',
    '//package/widgets/B9C80C792001B15095495FF4A661D20FD5C2B55C370EE299/assets/views/placeholder.ejs',
    '//package/widgets/B9C80C792001B15095495FF4A661D20FD5C2B55C370EE299/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.GoogleFolder', {
    }, {
        prefs: {
            folderID: {
                type: 'text',
                defaultValue: '',
                label: 'Shared Google Folder Link'
            },
            height: {
                type: 'number',
                defaultValue: 300,
                label: 'Height',
                showUnits: 'px',
                min: 170
            },
            title: {
                type: 'text',
                defaultValue: '',
                label: 'Title',
                accordion: 'Customise'
            },
            titlecolor: {
                type: 'colourpicker',
                defaultValue: '#ffffff',
                label: 'Title font colour',
                accordion: 'Customise'
            },  
            titlebg: {
                type: 'colourpicker',
                defaultValue: '#0071b9',
                label: 'Title background',
                accordion: 'Customise'
            },
            dropShadow: {
                type: 'boolean',
                label: 'Add a shadow',
                defaultValue: true,
                accordion: 'Customise'
            }
     },

        packageID: 'B9C80C792001B15095495FF4A661D20FD5C2B55C370EE299',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            var ID;
            if (this.prefs.folderID.value == "") {
                this.renderInEdit();
            } else {
                var googlefolder = this.prefs.folderID.value.split("id=");
                if (googlefolder.length<2) {
                    var googlefolder1 = this.prefs.folderID.value.split("folders/");
                    ID = googlefolder1[1].slice(0, -12);
                } else {
                    ID = googlefolder[1];
                }
                this.element.html(
                    this.view('main.ejs', {
                        height: this.prefs.height.value,
                        folderID: ID
                    })
                );
                this.customlook();
            } 
        },
        'widget.edit': function(el, ev, data) {
            this.renderInEdit();
        },
        'widget.save': function(el, ev, data) {
            this.renderInEdit();
        },
        renderInEdit : function() {
            this.element.html(
                this.view('placeholder.ejs', {
                    height: this.prefs.height.value
                })
            );
            this.customlook();
        },
        customlook : function() {
                if (this.prefs.dropShadow.value == true) {
                   this.element.find('.googlefolder').css('box-shadow','0 2px 8px rgba(0,0,0,0.5)');
                };

                var boxtitle =  this.element.find('.folder_boxtitle');
                if (this.prefs.title.value !== '') {
                    var titletext = this.prefs.title.value;       
                
                    boxtitle.html('<h4>'+titletext+'</h4>');
                    boxtitle.css('color',this.prefs.titlecolor.value);
                    boxtitle.css('background',this.prefs.titlebg.value);
                    boxtitle.css('padding','5px');
                }
        }
    });
});