Com.Frog.Utils.require(
    '//package/widgets/D1D46D3D2001BF2465331F3E2D76C50ED437A0ECB48C4515/assets/styles/main.css',
    '//package/widgets/D1D46D3D2001BF2465331F3E2D76C50ED437A0ECB48C4515/assets/views/main.ejs',
    '//package/widgets/D1D46D3D2001BF2465331F3E2D76C50ED437A0ECB48C4515/assets/views/house.ejs',
    '//package/widgets/D1D46D3D2001BF2465331F3E2D76C50ED437A0ECB48C4515/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.HousePoints-Display', {
    }, {
        prefs: {
            house1Points: {
                type: 'number',
                defaultValue: 100,
                label: 'House 1 points'
            },
            house2Points: {
                type: 'number',
                defaultValue: 0,
                label: 'House 2 points'
            },
            house3Points: {
                type: 'number',
                defaultValue: 0,
                label: 'House 3 points'
            },
            house4Points: {
                type: 'number',
                defaultValue: 0,
                label: 'House 4 points'
            },
            house5Points: {
                type: 'number',
                defaultValue: 0,
                label: 'House 5 points'
            },
            house6Points: {
                type: 'number',
                defaultValue: 0,
                label: 'House 6 points'
            },        
            house1: {
                type: 'text',
                defaultValue: 'Red House',
                label: 'House 1 name',
                accordion: 'Houses settings'
            },
            house1colour: {
                type: 'colourpicker',
                label: 'House 1 colour',
                defaultValue: '#FF0000',
                accordion: 'Houses settings'
            },
            house2: {
                type: 'text',
                defaultValue: '',
                label: 'House 2 name (leave blank if not required)',
                accordion: 'Houses settings'
            },
            house2colour: {
                type: 'colourpicker',
                label: 'House 2 colour',
                defaultValue: '#f48f42',
                accordion: 'Houses settings'
            },
            house3: {
                type: 'text',
                defaultValue: '',
                label: 'House 3 name (leave blank if not required)',
                accordion: 'Houses settings'
            },
            house3colour: {
                type: 'colourpicker',
                label: 'House 3 colour',
                defaultValue: '#f4dc41',
                accordion: 'Houses settings'
            },
            house4: {
                type: 'text',
                defaultValue: '',
                label: 'House 4 name (leave blank if not required)',
                accordion: 'Houses settings'
            },
            house4colour: {
                type: 'colourpicker',
                label: 'House 4 colour',
                defaultValue: '#41f441',
                accordion: 'Houses settings'
            },
            house5: {
                type: 'text',
                defaultValue: '',
                label: 'House 5 name (leave blank if not required)',
                accordion: 'Houses settings'
            },
            house5colour: {
                type: 'colourpicker',
                label: 'House 5 colour',
                defaultValue: '#41aff4',
                accordion: 'Houses settings'
            },
            house6: {
                type: 'text',
                defaultValue: '',
                label: 'House 6 name (leave blank if not required)',
                accordion: 'Houses settings'
            },
            house6colour: {
                type: 'colourpicker',
                label: 'House 6 colour',
                defaultValue: '#d041f4',
                accordion: 'Houses settings'
            },
            height: {
                type: 'number',
                label: 'Max Height',
                defaultValue: 300,
                showUnits: 'px',
                 min: 100,
                accordion: 'Advanced'
            },
            fontsize: {
                type: 'number',
                label: 'Font size',
                defaultValue: 16,
                showUnits: 'px',
                accordion: 'Advanced'
            },
            maxpoints: {
                type: 'number',
                label: 'Maximum Points (bar heights will be calculated from this)',
                defaultValue: 250,
                min: 100,
                accordion: 'Advanced'
            },
            width: {
                type: 'number',
                label: 'Width of each house',
                defaultValue: 100,
                showUnits: 'px',
                accordion: 'Advanced'
            }
        },

        packageID: 'D1D46D3D2001BF2465331F3E2D76C50ED437A0ECB48C4515',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.renderInEdit('live');
        },
        'widget.edit': function(el, ev, data) {
            this.renderInEdit('edit');
        },
        'widget.save': function(el, ev, data) {
            this.renderInEdit('edit');
        },
        renderInEdit : function(mode) {
            this.element.html(
                this.view('main.ejs')
            );
            this.element.find('.houses').html('');
            this.showHouse(this.prefs.house1.value,this.prefs.house1Points.value,this.prefs.house1colour.value);
            if (this.prefs.house2.value !== '') {
                this.showHouse(this.prefs.house2.value,this.prefs.house2Points.value,this.prefs.house2colour.value);

            }
            if (this.prefs.house3.value !== '') {
                this.showHouse(this.prefs.house3.value,this.prefs.house3Points.value,this.prefs.house3colour.value);

            }
            if (this.prefs.house4.value !== '') {
                this.showHouse(this.prefs.house4.value,this.prefs.house4Points.value,this.prefs.house4colour.value);

            }
            if (this.prefs.house5.value !== '') {
                this.showHouse(this.prefs.house5.value,this.prefs.house5Points.value,this.prefs.house5colour.value);

            }
            if (this.prefs.house6.value !== '') {
                this.showHouse(this.prefs.house6.value,this.prefs.house6Points.value,this.prefs.house6colour.value);
            }
            var elementheight = parseInt(this.prefs.height.value)+parseInt(this.prefs.fontsize.value)+10;
            this.element.find('.houses').css('height',elementheight+'px');
        },
        showHouse : function(house,housepoints,housecolour) {
            var percent = housepoints*100/this.prefs.maxpoints.value;

            this.element.find('.houses').append(
                this.view('house.ejs', {
                    house: house,
                    percent: percent,
                    housepoints: housepoints,
                    housecolour:  housecolour,
                    maxheight: this.prefs.height.value,
                    fontsize: this.prefs.fontsize.value
                })
            );
            this.element.find('.points-meter').css('width', this.prefs.width.value+'px')
        }
    });
});
