Com.Frog.Utils.require(
    '//package/widgets/22993BB22001BF23E7B1FFC50AD5D30B409B716CF09B0BBC/assets/styles/main.css',
    '//package/widgets/22993BB22001BF23E7B1FFC50AD5D30B409B716CF09B0BBC/assets/views/main.ejs',
    '//package/widgets/22993BB22001BF23E7B1FFC50AD5D30B409B716CF09B0BBC/widget.ejs'
).then(function() {
    
    var data_store = [];
    var data_store_uuid = '';

    Com.Frog.Controllers.Widget.extend('Widget.ImageSlider', {
    }, {
        prefs: {
            time_between_slides: {
                type: 'range',
                label: "Change how long each image is displayed",
                min: 2000,
                max: 10000,
                step: 1000,
                defaultValue: 5000,
            },
            transition_speed: {
                type: 'range',
                label: "Change the transition speed",
                min: 100,
                max: 4000,
                step: 100,
                defaultValue: 1500,
            },
            full_width: {
                type: 'boolean',
                label: 'Check to try full width slider',
                defaultValue: false,
                accordion: 'Advanced'
            },
            data_store: {
                type: 'hidden',
                label: "This is Hidden",
                defaultValue: "[]"
            },
             disable_animations: {
                type: "list",
                label: "Disable animations?",
                defaultValue: "mobile",
                accordion: 'Advanced',
                options : {
                    "No" : "no",
                    "On mobile only" : "mobile",
                    "Yes" : "yes"
                }
            }
        },

        packageID: '22993BB22001BF23E7B1FFC50AD5D30B409B716CF09B0BBC',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {
            
        },

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            
            var widget = this;
            var transition_speed = this.prefs.transition_speed.value;
            var time_between_slides = this.prefs.time_between_slides.value;
            var disable_animations = this.prefs.disable_animations.value;
            var basehtml = "<div class=\"slider-container\"><div class=\"wrap-slider\"><div class=\"slider\"><div class=\"inset\"></div></div></div></div>";
            var slides;
            var counter = 0;
            var device;
            if ($("html").hasClass("touch")) {
                device = "mobile";
            } else {
                device = "desktop";
            }
            
            if (this.prefs.full_width.value) {
                 widget.element.find('.slider-container').addClass("full-width");          
            }
            
            function animation() {
                counter ++;
				var margin = counter * -100;
                if (disable_animations == "yes" || (disable_animations == "mobile" && device == "mobile")) {
                    widget.element.find('.inset').css("marginLeft", margin+"%");
                    if(counter >= slides) {
                        counter = 0;
                        widget.element.find('.inset').css({marginLeft: "0px"});
                    }
                    setTimeout(animation, time_between_slides)
                } else {
                    var options = {
                        duration: transition_speed,
                        easing: 'swing'
                    };
                    widget.element.find('.inset').animate({
                        marginLeft: '-=100%'
                    }, $.extend(true, {}, options, {
                        complete: function() {
                            if(counter >= slides) {
                                counter = 0;
                                widget.element.find('.inset').css({marginLeft: "0px"});
                            }
                            setTimeout(animation, time_between_slides)
                        }
                    }));
                }
            }

            function slider() {
                widget.element.find('div.inset').empty();
                if(data_store.length > 0) {
                    
                    $.each(data_store, function(key, file) {
                        widget.element.find('div.inset').append("<div class=\"slide\"><img src=\""+file.url+"\" /></div>");
                    });
                     widget.element.find('div.inset').append("<div class=\"slide\"><img src=\""+data_store[0].url+"\" /></div>");
                    
                    var slider_width = (slides + 1) * 100;
                    var figure_width = 100 / (slides + 1);
                    
                    widget.element.find('div.inset').width(slider_width+"%");
                    widget.element.find('.wrap-slider .slide').width(figure_width+"%");
                    
                    if (slides > 1) {
                        setTimeout(animation, time_between_slides);
                    }
                    
                }
            }
            
            function GetDataStore2() {
                data_store = JSON.parse(widget.prefs.data_store.value);
                slides = data_store.length;
                slider();
            }
            
            GetDataStore2();
            
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
            
            var widget = this;
            var currentuser = FrogOS.getUser();
            var perms = this.options.sitePermission;    //admin, view, contribute
            var baseURL = Frog.Utilities.getBaseUrl();
            var site_uuid = this.options.site_uuid;
            var widget_instance_uuid = widget.options.content_uuid
            var display_mode = "icons";
            var sort_mode = "name";
            
            function AddToDataStore2() {
                widget.prefs.data_store.value = JSON.stringify(data_store);
                var $editor_panel = widget.element.closest('.sites_core').find('ol.sites-editor-prefs-list:eq(1)');
                var $data_store_pref = $editor_panel.find("input[name='data_store']");
                $data_store_pref.val(JSON.stringify(data_store));
                DisplayFiles();
            }
            
            function GetDataStore2() {
                 data_store = JSON.parse(widget.prefs.data_store.value);
                 DisplayFiles();
            }
            
            var DisplayFiles = function() {
               
                widget.element.find('ul.mysortable').empty();

                    $.each(data_store, function(key, file) {
                        widget.element.find('ul.mysortable').append("<li data-dadded=\""+file.dadded+"\" data-ext=\""+file.ext+"\" data-name=\""+file.name+"\" data-url=\""+file.url+"\" data-uuid=\""+file.uuid+"\" class=\"ui-state-default\">"+file.name+"<div class=\"thumbn\"><img src=\""+file.url+"\" /></div><div class=\"delete\"><span class=\"ui-icon ui-icon-trash\"></span></div><div class=\"sliderorder\"></div></li>");
                    });
            };


            /////////// btnUploader_click() /////////////////////////////////////////////////
            widget.element.find('li.upload-file').on('click', function(ev) {
                $('.os_core:first').trigger('os.app.upload', {
                    "data": {
                        "upload_type": "asset",
                        "site_uuid": site_uuid,
                        "focusApp": widget.element.closest('div.app_dialog'),
                        "callback": function(result) {
                            if (result.files && result.files.length) {
                                $.each(result.files, function(i, file) {
                                    if (file.attachment.file.mime.ext.toLowerCase() == "gif" || file.attachment.file.mime.ext.toLowerCase() == "jpeg" || file.attachment.file.mime.ext.toLowerCase() == "jpg" || file.attachment.file.mime.ext.toLowerCase() == "png") {
                                        data_store.push({uuid: file.uuid, name: file.attachment.name, ext: file.attachment.file.mime.ext, url:file.external_url, dadded:file.attachment.updated});
                                    }
                                });
                                AddToDataStore2();
                            }
                        }
                    }
                });
            });
            //////////////////////////////////////////////////////////////////////////////////////////////


            /////////// btnDelete_click() ///////////////////////////////////
            widget.element.find('div.mywrapper').on('click', ".delete", function(ev) { 
                var uuid = $(this).closest("li").data("uuid");
                data_store = data_store.filter(function (el) {
                    return el.uuid !== uuid;
                });
                $(this).closest("li").remove();
                AddToDataStore2();
            });
            //////////////////////////////////////////////////////////////////////
			
            widget.element.find(".mysortable").sortable({ 
                placeholder: "ui-sortable-placeholder",
                stop: function(event,ui) {
                    data_store = [];

                    widget.element.find(".mysortable li").each(function( index ) {
                        data_store.push({uuid: $(this).data("uuid"), name: $(this).data("name"), ext: $(this).data("ext"), url: $(this).data("url"), dadded: $(this).data("dadded")});
                    });

                    AddToDataStore2();

                }
            });

            GetDataStore2();

        },

        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {}
    });
});
