Com.Frog.Utils.require(
    '//package/widgets/57AF5E0B2001B0AD493C3FA9CC93430B57A70E4CF6DB90AD/assets/styles/main.css',
    '//package/widgets/57AF5E0B2001B0AD493C3FA9CC93430B57A70E4CF6DB90AD/assets/views/main.ejs',
    '//package/widgets/57AF5E0B2001B0AD493C3FA9CC93430B57A70E4CF6DB90AD/assets/views/navItem.ejs',
    '//package/widgets/57AF5E0B2001B0AD493C3FA9CC93430B57A70E4CF6DB90AD/assets/views/LO.ejs',
    '//package/widgets/57AF5E0B2001B0AD493C3FA9CC93430B57A70E4CF6DB90AD/assets/views/heading.ejs',
    '//package/widgets/57AF5E0B2001B0AD493C3FA9CC93430B57A70E4CF6DB90AD/assets/views/resource.ejs',
    '//package/widgets/57AF5E0B2001B0AD493C3FA9CC93430B57A70E4CF6DB90AD/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.LearningLocker', {
    }, {
        prefs: {
            teacherResources: {
                type: 'boolean',
                label: 'Show Teacher Resources',
                defaultValue: false
            },
            exemplarStd: {
                type: 'boolean',
                label: 'Show Exemplar Standards',
                defaultValue: true
            },
            learnerResources: {
                type: 'boolean',
                label: 'Show Learner Resources',
                defaultValue: true
            },
            learnerExt: {
                type: 'boolean',
                label: 'Show Extension Resources',
                defaultValue: true
            },
            lockerName: {
                type: 'text',
                label: 'LO Name',
                defaultValue: '',
                accordion: 'Advanced'
            },
            lockerUUID: {
                type: 'text',
                label: 'LO UUID',
                defaultValue: '',
                accordion: 'Advanced'
            },
            parents: {
                type: 'hidden',
                label: 'Parents UUID',
                defaultValue: ''
            }
        },
        packageID: '57AF5E0B2001B0AD493C3FA9CC93430B57A70E4CF6DB90AD',

        init: function() {},

        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            if (this.prefs.lockerUUID.value !== '') {
                this.find('.packaged-widget-placeholder--title').text( $.EJS.clean( this.prefs.lockerName.value ) );
                this.displayLockerContents();
            }
        },

        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
            this.element.find('.warning').hide();
            if (this.prefs.lockerUUID.value !== '') {
                this.getLearningObjectives( this.prefs.parents.value );
            } else {
                this.navigateToObjective();
            }
        },

        navigateToObjective: function( parents, path, type ) {
            var self = this,
                list = self.element.find('.curriculum'),
                backButton = self.element.find('.back_button'),
                parents_array = [];
            list.empty();     
            
            if (parents) {
                parents_array = parents.split(',');        
                backButton.attr('data-parents', parents.split(',').slice(0, -1).join(',') );
            } else {
                parents = '';
            }

            Frog.Model.api('curriculumassociations.get', {
                 parents: parents_array,
                 path: path
            }).done(function(cdResponse) {
                var list_items,
                    level;

                if (cdResponse.data.length !== 0) { // If there is a subject_area
                    if (path) {
                        list_items = cdResponse.data.data;
                        type = cdResponse.data.type;
                    } else {
                        list_items = cdResponse.data[0].data;
                        type = 'curriculum'
                    }
                    list.append( 
                        self.view( 'navItem.ejs' , {
                            list_items: list_items, 
                            parents: parents,
                            type: type
                        })
                    );
          
                } else {  // If there is not a subject_area
                    self.getLearningObjectives( parents );
                }
                
            }).fail(function(e) {
                // Report Error
                Frog.Controller.prototype.growl('Failed to load curriculum.','Curriculum Viewer','app-name',{time: 5000,  icon: 'externalapps/icon/'+self.packageID});
            });
        },
        
        getLearningObjectives: function( parents ) { // associations == parents
            var self = this,
                list = self.element.find('.curriculum'),
                associations_array = parents.split(',');

            list.empty();
            
            if (self.prefs.lockerUUID.value !== '') {
                var warn = self.element.find('.warning'),
                    backButton = self.element.find('.back_button');
                warn.empty();
                warn.append( $.EJS.clean(self.prefs.lockerName.value) );
                warn.addClass('alert-success');
                warn.show();   
                backButton.attr('data-parents', parents.split(',').slice(0, -1).join(',') );
            }
            
            Frog.Model.api('curriculumlearningobjectives.get', { 
                 associations: associations_array
            }).done(function(cdResponse) {
                var yearGroups = cdResponse.data;

                $.each(yearGroups, function(index, year) {
                    list.append( self.view('heading.ejs', {name: year.name}) );
                    
                    var objectives = year.objectives;
                    $.each(objectives, function(objective_index, LO) {
                        self.showLearningObjectives( LO.description, LO.uuid, parents, LO.is_kpi );
                        
                        if (LO.children.length > 0 ) {
                            $.each(LO.children, function(children_index, child) {
                                self.showLearningObjectives( child.description, child.uuid, parents, child.is_kpi );
                            })
                        } // end of LO children IF                      
                    }); // end of LO each
                }); // end of year each
                
            }).fail(function(e) {
                // Report Error
                Frog.Controller.prototype.growl('Failed to load objectives.','Curriculum Viewer','app-name',{time: 5000,  icon: 'externalapps/icon/'+self.packageID});
            });
        },
        showLearningObjectives: function( name, uuid, parents, kpi ) { 
            var self = this,
                list = self.element.find('.curriculum');
            list.append( 
                self.view( 'LO.ejs' , {
                    name: name,
                    uuid: uuid,
                    parents: parents
                })
            );
            if (kpi == true) {
                list.find('.KPI_'+uuid).show();
                list.find('.learning-objective_'+uuid).addClass('kpi_text');
            }
        },
                
        '.learning-objective_nav_item click': function(ev) {
            var item_parents = ev[0].dataset.parents,
                type = ev[0].dataset.type,
                path = 'year_group,subject,curriculum,subject_area';
            
            if (type == "back" && item_parents == '' ) {
                this.navigateToObjective();
            } else if (type !== 'subject_area') {
                this.navigateToObjective(item_parents, path);
            } else {
                this.getLearningObjectives(item_parents);
            }
        },
        '.learning-objective click': function(ev) {
            var uuid = ev[0].dataset.uuid,
                name = ev[0].dataset.name, 
                parents = ev[0].dataset.parents,
                self = this;
            
            self.prefs.lockerUUID.value = uuid;
            self.prefs.lockerName.value = name; 
            self.prefs.parents.value = parents;
            var warn = self.element.find('.warning');
            warn.empty();
            warn.append( $.EJS.clean(self.prefs.lockerName.value) );
            warn.addClass('alert-success');
            warn.show();          
        },
        
        displayLockerContents: function() {
            var self = this;

            Frog.Model.api('learninglocker.get', { 
                 uuid: self.prefs.lockerUUID.value
            }).done(function(lockerResponse) {
                var sections = lockerResponse.data,
                    resources = self.element.find('.resources');

                $.each(sections, function(index,section) {
                    if ((self.prefs.learnerResources.value && index == 'core') || (self.prefs.learnerExt.value && index == 'extension') || (self.prefs.exemplarStd.value && index == 'exemplar') || (self.prefs.teacherResources.value && index == 'teaching')) {

                        var sectionArea = self.element.find('.section'+index);
                        sectionArea.show();
                        $.each(section, function(index1,resource) { 
                            sectionArea.append( self.view('resource.ejs', { item: resource.resource }));
                        });
                        
                    }
                });
                
            }).fail(function(e) {
                // Report Error
                Frog.Controller.prototype.growl('Failed to load locker contents.','Curriculum Viewer','app-name',{time: 5000,  icon: 'externalapps/icon/'+self.packageID});
            });
        },

        
        'widget.updated': function(el, ev, data) {}
    });
});
