Com.Frog.Utils.require(
    '//package/widgets/10FC52112001B24FF66E7F8FE24DE30ED20C6B9C67E190CC/assets/styles/main.css',
    '//package/widgets/10FC52112001B24FF66E7F8FE24DE30ED20C6B9C67E190CC/assets/views/main.ejs',
    '//package/widgets/10FC52112001B24FF66E7F8FE24DE30ED20C6B9C67E190CC/assets/views/modal.ejs',
    '//package/widgets/10FC52112001B24FF66E7F8FE24DE30ED20C6B9C67E190CC/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.LinkLog', {
    }, {
        prefs: {
            resource_url: {
                type: 'upload',
                filter: null,
                sources: ['native'],
                label: 'File',
                defaultValue: ''
            },
            hyperlink: {
                type: 'text',
                label: 'Web link (Leave blank or this setting will override the file option)',
                defaultValue: ''
            },
            resource_name: {
                type: 'text',
                label: 'Link Name',
                placeholder: "Link to file / webpage",
                defaultValue: 'Click this link'
            },
            fileicon: {
           		type: "list",
           		label: "File Type",
           		defaultValue: "rtf",
           		options : {
					"PDF" : "pdf",
					"Powerpoint" : "pptx",
                    "Word Doc" : "docx",
           			"Spreadsheet" : "xlsx",
                    "Video" : "mp4",
                    "Image" : "jpg",
                    "Audio" : "mp3",
                    "eBook" : "epub",
                    "OneNote" : "one",
                    "Other" : "rtf",
           		},
                accordion: 'Design'
           },
            resource_desc: {
                type: 'text',
                label: 'Description (if required)',
                defaultValue: ''
            },
           force_download: {
                type: 'boolean',
                label: 'Force the browser to download file (useful for PDFs, images etc...)',
                defaultValue : true,
                accordion: 'Advanced'
            },
            dateorder: {
                type: 'radio',
                label: "Analytics Date order",
                vertical: true,
                options: {
                     'DD/MM/YY': 'uk',
                     'MM/DD/YY': 'us'
                },
                defaultValue: "uk",
                publish: [],
                accordion: 'Advanced'
            }
        },
        users: [],
        visit_data: [],

        packageID: '10FC52112001B24FF66E7F8FE24DE30ED20C6B9C67E190CC',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
       'widget.live': function(el, ev, data) {         
            this.element.html(
                this.view('main.ejs')
            );
    		this.edit_mode = false;
            this.renderInEdit();
           
            if (this.options.sitePermission === 'admin') {
                this.element.find('.stats').show();
            } else {
                this.element.find('.stats').hide();
            }
       },
       '.linklozenge {click}': function() {
            if (this.edit_mode === false) {
                if (this.prefs.resource_url.value !== '') {
                    Frog.Utilities.download(
                        this.prefs.resource_url.value + (this.prefs.force_download.value ? '?mode=download' : ''),true
                    );
                }
                if (this.prefs.hyperlink.value !== '') {
                    var win = window.open(this.prefs.hyperlink.value, '_blank');
                    win.focus();
                }
                FrogOS.fdp({
                    url: 'datastore/get',
                    path: '/api/fdp/2/',
                    type: 'GET',
                    data: {
                        target_uuid: this.options.content_uuid,
                        alias: 'link_clicks',
                        user_uuid: FrogOS.getUser().uuid
                    }
                }).done(function(response) {
                    var visit_data,
                        is_update = false;
                    if (response.response.length) {
                        visit_data = JSON.parse(response.response[0].data);
                        is_update = response.response[0].uuid;
                    } else {
                        visit_data = {
                            user_uuid: FrogOS.getUser().uuid,
                            visits: []
                        }
                    }
                    this.logVisit(visit_data, is_update);
                }.bind(this)).fail(function(e) {
                    // Report Error
                    console.log("failed");
                });
            } // end of edit mode
        },
        
        logVisit: function(visit_data, is_update)
        {
            visit_data.visits.push(moment().unix());
            visit_data = JSON.stringify(visit_data);
            var method = 'datastore/create',
                data = {
                    target_uuid: this.options.content_uuid,
                    data: visit_data,
                    alias: 'link_clicks',
                    user_uuid: FrogOS.getUser().uuid
                };

            if (is_update) {
                method = 'datastore/update';
                data.uuid = is_update
            }
            
            FrogOS.fdp({
                url: method,
                path: '/api/fdp/2/',
                type: 'POST',
                data: data
            }).done(function(response) {
                // Do things
                //console.log("done");
            }).fail(function(e) {
                // Report Error
                console.log("failed");
            });
        },
        
        '[data-action="get-stats"] click': function(el, ev) {
            if (this.edit_mode === false) {
                ev.stopPropagation();
                this.visit_data = {};
                this.total_visit_count = 0;
                this.users = [];

                FrogOS.fdp({
                    url: 'datastore/get',
                    path: '/api/fdp/2/',
                    type: 'GET',
                    data: {
                        target_uuid: this.options.content_uuid,
                        alias: 'link_clicks'
                    }
                }).done(function(response) {
                    var uuids = [],
                        requests = [],
                        tmp = [];

                    for (var i = 0; i < response.response.length; i++) {
                      uuids.push(response.response[i].user_uuid);
                      var data = JSON.parse(response.response[i].data);
                      this.visit_data[data.user_uuid] = data.visits;
                      this.total_visit_count += data.visits.length;
                    }

                   while (uuids.length > 0) {
                       tmp = uuids.splice(0, 50);
                       if (tmp.length > 0) {
                           var req = this.getUsers(tmp);
                           requests.push(req);
                       }
                   }

                   $.when.apply($, requests).then(function() {
                       this.renderData();
                   }.bind(this));                     
                }.bind(this));
            } // end of if edit_mode
        },

        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            this.edit_mode = true;
            this.renderInEdit();

        },
        'widget.save': function(el, ev, data) {
            this.edit_mode = true;
            this.renderInEdit();
        },

         renderInEdit : function() {

             this.element.find('h2').text(this.prefs.resource_name.value);
             if (!this.prefs.resource_url.value && this.prefs.hyperlink.value == '') {
                 this.element.find('p').text("CAUTION: No file or link set");
             } else {
                 this.element.find('p').text(this.prefs.resource_desc.value);
             }
		 	 this.element.find('.fileicon').removeClass('os-icon-ext-pdf');
		 	 this.element.find('.fileicon').removeClass('os-icon-ext-pptx');
		 	 this.element.find('.fileicon').removeClass('os-icon-ext-xlsx');
		 	 this.element.find('.fileicon').removeClass('os-icon-ext-docx');
		 	 this.element.find('.fileicon').removeClass('os-icon-ext-one');
		 	 this.element.find('.fileicon').removeClass('os-icon-ext-mp4');
		 	 this.element.find('.fileicon').removeClass('os-icon-ext-jpg');
		 	 this.element.find('.fileicon').removeClass('os-icon-ext-mp3');
		 	 this.element.find('.fileicon').removeClass('os-icon-ext-epub');
		 	 this.element.find('.fileicon').removeClass('os-icon-ext-rtf');
             this.element.find('.fileicon').removeClass('os-icon-ext-link');
		 	 var icon = 'os-icon-ext-'+this.prefs.fileicon.value;
             if (this.prefs.hyperlink.value!== "") {
                 icon = 'os-icon-ext-link';
             }
		 	 this.element.find('.fileicon').addClass(icon);
        },

        'widget.updated': function(el, ev, data) {},
        'onlyUnique' : function(value, index, self) { 
            return self.indexOf(value) === index;
        },

         getUsers: function(uuids) {
             var deferred = $.Deferred();

             Frog.Widget.Model.api('users.getSummary', { 'uuid' : uuids }, {
              'type': 'GET',
                'dataType': 'json users',
                'converters': {
                    'json users': function(response) {
                        return response.data;
                    }
                }
            }).done(function(users) {
                 for(var i = 0; i < users.length; i++) {
                     this.users.push(users[i]);
                 }
              deferred.resolve();
            }.bind(this)).error(function(err) {
              deferred.reject();
            }.bind(this));

            return deferred.promise();
      },
        
      renderData: function() {
          var container = this.element.find('.table-data');

          var rows = '';
          for (var i = 0; i < this.users.length; i++) {
              var user_total_visit_count = this.visit_data[this.users[i].uuid].length,
                  latest_visit = this.visit_data[this.users[i].uuid].pop(),
                  childnames = "";
              
              var dateorder = moment.unix(latest_visit).format('DD/MM/Y'),
                   yeargroup = '';
              if (this.prefs.dateorder.value === "us") {
                   dateorder = moment.unix(latest_visit).format('MM/DD/Y')
              };
              if (this.users[i].group_types.year) {
                  yeargroup = this.users[i].group_types.year.groups;
              };

              var row = '<tr><td>'+this.users[i].details.forename+' '+this.users[i].details.surname+'</td>'+
                  '<td>'+this.users[i].profile.type+'</td>'+
                  '<td>'+this.users[i].username+'</td>'+
                  '<td>'+yeargroup+'</td>'+
                  '<td>'+user_total_visit_count+'</td>'+
                  '<td>'+dateorder+'</td>'+
                  '<td>'+moment.unix(latest_visit).format('HH:mm')+'</td></tr>';
              rows += row;
              } // end of loop
              var tabl = '<div class="linklog_total_count">Total clicks: '+this.total_visit_count+'</div>'+
                      '<table class="linklog_sitestats">'+
                          '<thead><tr>'+
                              '<td>Display Name</td>'+
                              '<td>Profile</td>'+
                              '<td>Username</td>'+
                              '<td>Year group</td>'+
                              '<td>Click Count</td>'+
                              '<td>Last Date</td>'+
                              '<td>Time of click</td>'+
                          '</tr></thead>'+
                      '<tbody class="table-data">'+rows+'</tbody>'+	
                      '</table>';

              this.modal('Click analytics',this.view('modal.ejs',{
                    table: tabl
              }));
          
          
          }
    });
});
