Com.Frog.Utils.require(
    '//package/widgets/15D019B82001B56B67685F84C40B8F023F90300CF221D60D/assets/styles/main.css',
    '//package/widgets/15D019B82001B56B67685F84C40B8F023F90300CF221D60D/assets/views/main.ejs',
    '//package/widgets/15D019B82001B56B67685F84C40B8F023F90300CF221D60D/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.LinktoFileLozenge', {
    }, {
        prefs: {
			resource_url: {
                type: 'upload',
                filter: null,
                sources: ['native'],
                label: 'Upload or link to a file',
                defaultValue: ''
            },
            resource_name: {
                type: 'text',
                label: 'Name of File',
                placeholder: "Link to file",
                defaultValue: ''
            },
            fileicon: {
           		type: "list",
           		label: "File Type",
           		defaultValue: "rtf",
           		options : {
					"PDF" : "pdf",
					"Powerpoint" : "pptx",
                    "Word Doc" : "docx",
           			"Spreadsheet" : "xlsx",
                    "Video" : "mp4",
                    "Image" : "jpg",
                    "Audio" : "mp3",
                    "eBook" : "epub",
                    "OneNote" : "one",
                    "Other" : "rtf",
           		}
           },
            force_download: {
                type: 'boolean',
                label: 'Force the browser to download file (useful for PDFs, images etc...)',
                defaultValue : true,
                accordion: 'settings.advanced'
            },
            resource_desc: {
                type: 'text',
                label: 'Description (if required)',
                defaultValue: '',
                accordion: 'settings.advanced'
            },
        },
        edit_mode : false,

        packageID: '15D019B82001B56B67685F84C40B8F023F90300CF221D60D',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        
		'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
    		this.edit_mode = false;
            this.renderInEdit();
            
        },
        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            this.edit_mode = true;
            this.renderInEdit();

        },

        'widget.save': function(el, ev, data) {
            this.edit_mode = true;
            this.renderInEdit();
        },
         renderInEdit : function() {
             if (this.prefs.resource_name.value!=="") {
			         this.element.find('h2').text(this.prefs.resource_name.value);
             } else {
                 this.element.find('h2').text('Link to file');
             }
             if (!this.prefs.resource_url.value) {
                 this.element.find('p').text("CAUTION: No file selected");
             } else {
		 	     this.element.find('p').text(this.prefs.resource_desc.value);
             }
		 	 this.element.find('.fileicon').removeClass('os-icon-ext-pdf');
		 	 this.element.find('.fileicon').removeClass('os-icon-ext-pptx');
		 	 this.element.find('.fileicon').removeClass('os-icon-ext-xlsx');
		 	 this.element.find('.fileicon').removeClass('os-icon-ext-docx');
		 	 this.element.find('.fileicon').removeClass('os-icon-ext-one');
		 	 this.element.find('.fileicon').removeClass('os-icon-ext-mp4');
		 	 this.element.find('.fileicon').removeClass('os-icon-ext-jpg');
		 	 this.element.find('.fileicon').removeClass('os-icon-ext-mp3');
		 	 this.element.find('.fileicon').removeClass('os-icon-ext-epub');
		 	 this.element.find('.fileicon').removeClass('os-icon-ext-rtf');
		 	 var icon = 'os-icon-ext-'+this.prefs.fileicon.value;
		 	 this.element.find('.fileicon').addClass(icon);
        },

        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {

        },
        '.linktofilelozenge {click}': function() {
            if (this.edit_mode === false) {
                Frog.Utilities.download(
                    this.prefs.resource_url.value +
                        (this.prefs.force_download.value ? '?mode=download' : ''),
                    true
                );
            }
        }
    });
});