/**
 * @class Widget.Models.Eportfolio
 */
Frog.Widget.Model.extend('Widget.Models.Eportfolio', {
    getMyEportfolios: function (params) {
        params = $.extend({}, params, {'type': 'my_eportfolios'});

        return this.api('sites.getSitesByAssociation',
            params,
            {
            "dataType": "json sites",
            "type" : "GET",
            "converters": {
                "json sites": function( res ) {
                    var sites = Object.values(res.data[0].children);

                    return Lib.Models.Site.models(sites);
                }
            }
        });
    },

    getMyChildsEportfolios: function (params) {
        params = $.extend({}, params, {'type': 'my_childs_eportfolios'});

        return this.api('sites.getSitesByAssociation',
            params,
            {
                "dataType": "json sites",
                "type" : "GET",
                "converters": {
                    "json sites": function( res ) {
                        var sites = Object.values(res.data[0].children);

                        return Lib.Models.Site.models(sites);
                    }
                }
            });
    }
}, {});
