Com.Frog.Utils.require(
    '//package/widgets/53C969442001B1AD85FB3F32C33C9F0843780B7C91905176/assets/styles/main.css',
    '//package/widgets/53C969442001B1AD85FB3F32C33C9F0843780B7C91905176/assets/views/main.ejs',
    '//package/widgets/53C969442001B1AD85FB3F32C33C9F0843780B7C91905176/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.ePortfolioUpdateNotification', {
    }, {
        prefs: {
            usernamePos: {
	           type: 'list',
	           label: 'Is the username in position 2 or 3 in the ePortfolio title? i.e. Site Title [#1] - Name [#2] - Username [#3]',
	           defaultValue: '2',
	           options: {
	               'Position 2': '1',
	               'Position 3': '2'
               }
           },
           buttonLabel: {
               type: 'text',
               label: 'Button Label',
               defaultValue: 'Send update notification'
           },
           messageText: {
               type: 'text',
               label: 'Message',
               defaultValue: 'Your ePortfolio has been updated',
           },
           parentSend: {
               type: 'boolean',
               label: 'Send Frog notification to the parents/carers of the pupil',
               defaultValue: false,
               accordion: 'Frog Notification Recipients'
           },
           relationshipUuid: {
               type: 'text',
               label: 'Relationships Category UUID in Users App (required if you are sending Frog notifications to parents)',
               defaultValue: 'CF00406E2004CF931A484F4CE6F6B60B084DE01C681D654D',
               accordion: 'Frog Notification Recipients'
           },
           myFrogNotification: {
               type: 'radio',
               label: 'MyFrog Push Notification',
               vertical: true,
               options: {
                   'Do not send': 'none',
                   'ePortfolio Recipient': 'groupOnly',
                   'Child and Parent/Carer': 'groupAndGuardian',
                   'Parents and Carers only': 'guardian'
               },
               defaultValue: 'none',
               publish: [],
               accordion: 'MyFrog Notification'
           },
           myFrogMsg: {
               type: 'text',
               label: 'MyFrog Message',
               defaultValue: 'A teacher has made a comment on your ePortfolio',
               accordion: 'MyFrog Notification'
           }
        },

        packageID: '53C969442001B1AD85FB3F32C33C9F0843780B7C91905176',

        init: function() {},

        'widget.live': function(el, ev, data) { 
            this.element.html(
                this.view('main.ejs')
            );
        },
        
        '.updateNotfication click': function() { 
            // First, get the site's title.  This contains the student's username.  We use this to identify the student to sent a notifcation to.
            var siteName = this.element.closest('.sites-site-content').data('site-name'),
    			siteNameArray = siteName.split(' - '),
    			recipientUsername = siteNameArray[this.prefs.usernamePos.value],
                self = this;

            if (recipientUsername) {
                Frog.Model.api('users.getSummary', { // Search for the user using the Users App API   
                    search: recipientUsername,
                    direction: 'asc',
                    group_types: 'registration|year',
                    profile: 'profile-student',
                    sortBy: 'surname'
                }).done(function(detailsResponse) {
                    var userDetails = detailsResponse.data[0],
                        recipients = userDetails.uuid;
                
                    if (self.prefs.relationshipUuid.value !== '' && self.prefs.parentSend.value) { 
                        Frog.Model.api('users.getDataInCategory', { 
                            uuid: self.prefs.relationshipUuid.value,
                            user_uuid: userDetails.uuid
                        }).done(function(relationshipResponse) {
                            var relations = relationshipResponse.data.relationships;
                            $.each(relations, function(index,relation) {
                                // flags[2] = parental_responsibility
                                // flags[4] = allow_access
                                if (relation.flags[2].selected === true && relation.flags[2].selected === true) {
                                    recipients += ','+relation.user_uuid;
                                }
                                if (index == relations.length-1) {
                                    self.sendFrogNotification(recipients);
                                }
                            });
                        }).fail(function(e) { 
                            self.showGrowl('Failed to find parents');
                        });  
                    } else { // if not sending to parents
                        self.sendFrogNotification(recipients);
                    }
                    if (self.prefs.myFrogNotification.value !== 'none') {
                        self.sendToMyFrog(recipients);
                    }
                }).fail(function(e) { 
                    self.showGrowl('Failed to identify recipient');
                });
            } else {
                self.showGrowl('No username found in ePortfolio title');
            }
        },
        
        sendFrogNotification: function(recipients) {
            var self = this;
            FrogOS.fdp({
                url: 'notification/send',
                path: '/api/fdp/2/',
                type: 'POST',
                data: {
                    message: self.prefs.messageText.value,
                    recipients: recipients
                }
            }).done(function(response) {
                self.showGrowl('Notification sent');
            }).fail(function(e) {
                self.showGrowl('Failed to send Notification');
            });
        },
        
        sendToMyFrog: function(studentUuid) {
            var self = this;

            Frog.Model.api('messages.create', {
                message: self.prefs.myFrogMsg.value,
                sendTo: {
                    0: {
                        sendTo: self.prefs.myFrogNotification.value,
                        uuid: studentUuid
                    }
                },
                title: self.prefs.messageText.value
            },{
                type: 'POST'
            }).done(function() {
                self.showGrowl('MyFrog Notification sent');
            }).fail(function(e) {
                self.showGrowl('Failed to send to MyFrog');
            });
        },
            
        showGrowl: function(string) {
            var icon = 'externalapps/icon/'+this.packageID;
            Frog.Controller.prototype.growl(string,'ePortfolio Update','app-name',{time:'5000', icon: icon});
        },
        
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        },

        'widget.updated': function(el, ev, data) {}
    });
});
