Com.Frog.Utils.require(
    '//package/widgets/49A41DDA2001B8200C4AEF11DF7EA80BBA0DE7ECCBB8829D/assets/styles/main.css',
    '//package/widgets/49A41DDA2001B8200C4AEF11DF7EA80BBA0DE7ECCBB8829D/assets/views/main.ejs',
    '//package/widgets/49A41DDA2001B8200C4AEF11DF7EA80BBA0DE7ECCBB8829D/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.OpenDyslexicFont', {
    }, {
        prefs: { 
        },

        packageID: '49A41DDA2001B8200C4AEF11DF7EA80BBA0DE7ECCBB8829D',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            this.element.find('#Dyslexictoggle').on('click', function() {
                this.addFont();
            }.bind(this));
        },
        "addFont" : function() {
                var button = this.element.find('#Dyslexictoggle'),
                    dyslexicStyle = this.element.find('.dyslexicStyle');
                if(button.val()<1) {
                    button.val(1);
                    button.attr('checked','checked');
                    dyslexicStyle.html(
                        '<style>'+
                        '.widget_text, .widget_notice, .widget_notes, .widget_forms, .widget_filelink, h1, h2, h3, h4, h5, h6, p {'+
                            'font-family: "openDyslexic" !important;'+
                        '}'+
                        '</style>'
                    );
                } else {
                    button.val(0);
                    button.removeClass('checked');
                    dyslexicStyle.html('');
                }            
        },
        '.dropdown-menu a {click}' : function(ev) {
            var colour = ev.data("colour");
            if (colour !== "none") {
                this.element.find('.pageBGStyle').html(
                        '<style>'+
                        '.content {'+
                            'background: #'+colour+';'+
                        '}'+
                        '</style>'
                    );
            } else {
                this.element.find('.pageBGStyle').empty();
            }
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        },

        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {}
    });
});
