Com.Frog.Utils.require(
    '//package/widgets/D334C1AC2001B63C4CBFBF320AFF9206A62AD1FC4CF371A4/assets/styles/main.css',
    '//package/widgets/D334C1AC2001B63C4CBFBF320AFF9206A62AD1FC4CF371A4/assets/views/main.ejs',
    '//package/widgets/D334C1AC2001B63C4CBFBF320AFF9206A62AD1FC4CF371A4/assets/views/counter.ejs',
    '//package/widgets/D334C1AC2001B63C4CBFBF320AFF9206A62AD1FC4CF371A4/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.OpinionLine', {
    }, {
       prefs: {
            "question": {
                "type":"text",
                "defaultValue":"Question",
                "label":"Question"
            },
            "left": {
                "type":"text",
                "defaultValue":"Left",
                "label":"Left-hand opinion"
            },
            "right": {
                "type":"text",
                "defaultValue":"Right",
                "label":"Right-hand opinion"
            }
        },

        packageID: 'D334C1AC2001B63C4CBFBF320AFF9206A62AD1FC4CF371A4',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            this.element.find('.hideAll').on('click',function(ev) {
                $('.hide').hide();
            });
            this.element.find('.opinionPlus').on('click',function(ev) {
               var position = $(ev.target).position(),
                   $counter = $(this.view('counter.ejs'));
                   $counter.css({
                       position:'absolute',
                       top:position.top-25,
                       left:position.left,
                       color:'#'+(Math.random()*0xFFFFFF<<0).toString(16)
                   })
                   .on('click',function(counterEv) {
                       $(counterEv.target).find('.hide').toggle().focus();
                   })
                   .draggable();
                   $(ev.target).parent().append($counter);
            }.bind(this));
        },
        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.renderInEdit();
        },
        'widget.save': function(el, ev, data) {
            this.renderInEdit();
        },
        renderInEdit : function() {
            this.element.html(
                this.view('main.ejs')
            );
            this.element.find('.opinionHeader').text(this.prefs.question.value);
            this.element.find('.opinionLeft').text(this.prefs.left.value);
            this.element.find('.opinionRight').text(this.prefs.right.value);
            this.element.find('.opinionPlus').css('visibility', 'hidden');
            this.element.find('.hideAll').css('visibility', 'hidden');
        }
    });
});
