Com.Frog.Utils.require(
    '//package/widgets/49EF0FB72001B8093D66DF3DEFC6810AF142759C3E7AFD45/assets/styles/main.css',
    '//package/widgets/49EF0FB72001B8093D66DF3DEFC6810AF142759C3E7AFD45/assets/views/main.ejs',
    '//package/widgets/49EF0FB72001B8093D66DF3DEFC6810AF142759C3E7AFD45/assets/views/row.ejs',
    '//package/widgets/49EF0FB72001B8093D66DF3DEFC6810AF142759C3E7AFD45/assets/views/list.ejs',
    '//package/widgets/49EF0FB72001B8093D66DF3DEFC6810AF142759C3E7AFD45/assets/views/box.ejs',
    '//package/widgets/49EF0FB72001B8093D66DF3DEFC6810AF142759C3E7AFD45/assets/views/lozenge.ejs',
    '//package/widgets/49EF0FB72001B8093D66DF3DEFC6810AF142759C3E7AFD45/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.PageHeadlines', {
    }, {
        prefs: {
            headlinesize: {
                label: 'Font size',
                type: 'number',
                showUnits: 'px',
                defaultValue: 20
            },
            headlinecolour: {
                label: 'Text colour',
                type: 'colourpicker',
                defaultValue: '#FF0000'
            },
            viewtype: {
                label: 'View type',
                type: 'radio',
                vertical: true,
                options: {
                    'Vertical List': 'list',
                    'Boxes': 'box',
                    'Headlines': 'row',
                    'Lozenge': 'lozenge'
                },
                defaultValue: 'list',
                publish: []
            },
            page: {
                type: 'pagepicker',
                label: 'Select parent page (leave blank if widget at top level)',
                defaultValue: JSON.stringify({
                    page_uuid:'',
                    site_uuid:''
                }),
                accordion: 'Advanced'
            },
            pageUuid: {
                label: 'Page UUID',
                type: 'text',
                defaultValue: '',
                accordion: 'Advanced'
            },
            showTopPage: {
                label: 'Show Top Level page link',
                type: 'boolean',
                defaultValue: false,
                accordion: 'Advanced'
            },
            showSubPages: {
                label: 'Show 3rd tier pages',
                type: 'boolean',
                defaultValue: false,
                accordion: 'Advanced'
            }
        },

        packageID: '49EF0FB72001B8093D66DF3DEFC6810AF142759C3E7AFD45',

        init: function() {},

        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            this.getPageNavigation();
        },
       
        getPageNavigation : function() {
            var self = this,
                mainPageUuid = self.options.parentPages, // sets the parent page as the top-level page the widget is on.
                menuDiv = self.element.find('.menuGoesHere');
            
            if (self.prefs.pageUuid.value !== '') { // If a pref has been stored in plain text,
                mainPageUuid = self.prefs.pageUuid.value; // then set this value for the main page - enanle quick resuse of widget on multiple pages
            } else { // if no plain text pref value
                if (self.prefs.page.value !== JSON.stringify({"page_uuid":"","site_uuid":""})) { // check if the page picker has a value
                    mainPageUuid = JSON.parse(self.prefs.page.value).page_uuid; // sets the page the menu will look at.
                }
            }
            
            Frog.Model.api('pages.getNavigation', { 
                site: self.options.site_uuid
            }).done(function(res) {     
                menuDiv.empty();
                self.getStartingPage(res.data.children, mainPageUuid);
            });
        },
        
        getStartingPage : function(allPages, mainPageUuid) {
            var self = this;
            $.each(allPages, function(key, pageTier1) {
                if (pageTier1.node.uuid == mainPageUuid) {
                    self.getSubPages(pageTier1);
                } else if (pageTier1.hasOwnProperty("children")) {
                    $.each(pageTier1.children, function(k2, pageTier2) { 
                        if (pageTier2.node.uuid == mainPageUuid) {
                            self.getSubPages(pageTier2);
                        };
                    });
                } 
            });
        },
        
        getSubPages : function(pageObj) {
            var self = this;
            if (self.prefs.showTopPage.value) {
                self.renderLink(pageObj.node);
            }
            $.each(pageObj.children, function(key, pageLevel2) {
                self.renderLink(pageLevel2.node);
                if (pageLevel2.hasOwnProperty("children") && self.prefs.showSubPages.value) {
                    $.each(pageLevel2.children, function(key2, pageLevel3) { 
                        self.renderLink(pageLevel3.node);
                    });
                }; 
            }); 
        },
        
        renderLink : function(pageInfo) {
            var self = this,
                baseURL= Frog.Utilities.getBaseUrl(),
                page_icon = baseURL+'/app/package/widgets/49EF0FB72001B8093D66DF3DEFC6810AF142759C3E7AFD45/assets/newsfeed_site_icon.png',
                menuDiv = self.element.find('.menuGoesHere'),
                viewType = self.prefs.viewtype.value+'.ejs';
            
            if (pageInfo.visible === true && pageInfo.show_in_navigation === true) {   
                if (pageInfo.page_icon !== null) {
                    page_icon = pageInfo.page_icon;
                }
                menuDiv.append(self.view(viewType, {
                    pagelink: pageInfo.link,
                    alt: pageInfo.link,
                    pic: page_icon,
                    headline: pageInfo.name
                }));
            
                if (self.prefs.viewtype.value == 'list' || self.prefs.viewtype.value == 'box') {
                    self.element.find('.list').css('font-size', self.prefs.headlinesize.value+'px');
                    self.element.find('.list').css('color', self.prefs.headlinecolour.value);
                }
            }
        },

        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        },
        'widget.save': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
            if (this.prefs.page.value !== JSON.stringify({"page_uuid":"","site_uuid":""})) {
                this.prefs.pageUuid.value = JSON.parse(this.prefs.page.value).page_uuid;
            }
        },
        'widget.updated': function(el, ev, data) {
        }
    });
});
