Com.Frog.Utils.require(
    '//package/widgets/4B5731072001B993E7C26F317B9E890E8F43BB3C14F253E1/assets/styles/main.css',
    '//package/widgets/4B5731072001B993E7C26F317B9E890E8F43BB3C14F253E1/assets/views/main.ejs',
    '//package/widgets/4B5731072001B993E7C26F317B9E890E8F43BB3C14F253E1/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.PersonalisedWelcome', {
    }, {
        prefs: {
            "begin": {
                type:"text",
                defaultValue:"Welcome ",
                label:"Text in front of name"
            },
            "end": {
                type:"text",
                defaultValue:"!",
                label:"Text after name"
            },
            "fontsize": {
                type:"number",
                defaultValue:16,
                label:"Text size",
                accordion: 'settings.advanced'
            },
            "bold": {
                type:"boolean",
                defaultValue:"false",
                label:"Bold name?",
                accordion: 'settings.advanced'
            },
            "style": {
                type:"text",
                defaultValue:"",
                label:"Stylesheet",
                accordion: 'settings.advanced'
            }
        },

        packageID: '4B5731072001B993E7C26F317B9E890E8F43BB3C14F253E1',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.EditUpdate();
            var name = this.element.find('.person'),
                user = FrogOS ? FrogOS.getUser() : this.getUser();
            	name.text(user.attr('displayname'));
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
           this.EditUpdate();
        },
        'widget.save': function(el, ev, data) {      
            this.EditUpdate();
        },        
        EditUpdate : function() {
            this.element.html(
                this.view('main.ejs')
            );
			this.element.find('.welcome').css("font-size",this.prefs.fontsize.value+"pt");  
            this.element.find('.welcome').css("line-height",this.prefs.fontsize.value+"pt");  
            this.element.find('.welcome').html(	
                this.prefs.begin.value+
                '<span class="person">[Your Name]</span>'+
                this.prefs.end.value
            );
            if (this.prefs.bold.value===true) {
                 this.element.find('.person').css('font-weight','bold');
            }
            this.element.find('.welcome').attr(this.prefs.style.value);
        },

        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {}
    });
});
