Com.Frog.Utils.require(
    '//package/widgets/E81A1B7A2001B58015566F75D9049F0A754B6C7C38E3C88F/assets/styles/main.css',
    '//package/widgets/E81A1B7A2001B58015566F75D9049F0A754B6C7C38E3C88F/assets/views/main.ejs',
    '//package/widgets/E81A1B7A2001B58015566F75D9049F0A754B6C7C38E3C88F/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.QRCode', {
    }, {
        prefs: {
            url: {
                type: "text",
                label: "Web address, leave blank if for this site",
                defaultValue: ""
            },
            size: {
                type: "number",
                label: "Size",
                showUnits: "px",
                defaultValue: 150
            },
            showAddress: {
                label: "Show Web Address",
                type: "boolean",
                defaultValue: false
            },
            showQR: {
                label: "Show QR Code",
                type: "boolean",
                defaultValue: true
            }
        },

        packageID: 'E81A1B7A2001B58015566F75D9049F0A754B6C7C38E3C88F',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.renderInEdit('live');
        },
        'widget.edit': function(el, ev, data) {
            this.renderInEdit('edit');
        },
        'widget.save': function(el, ev, data) {
            this.renderInEdit('edit');
        },
        renderInEdit : function(mode) {
            var url = "";
            if (this.prefs.url.value == "") {
                url = Frog.Utilities.getBaseUrl()+'/'+this.options.externalUrl;
            } else {
                url = this.prefs.url.value;
            };
            this.element.html(
                this.view('main.ejs', {
                    size: this.prefs.size.value,
                    url: url
                })
            );
            if (this.prefs.showAddress.value == false) {
                this.element.find('.address').hide();
            };
            if (this.prefs.showQR.value == false) {
                this.element.find('.qrcode').hide();
            };
            if (mode === 'edit') {
                this.element.find('.qrlink').removeAttr('href');
            }
        }
    });
});
