Com.Frog.Utils.require(
    '//package/widgets/C582C3F92001B1E424327F69C7D765092D90A05C98274B26/assets/styles/main.css',
    '//package/widgets/C582C3F92001B1E424327F69C7D765092D90A05C98274B26/assets/views/main.ejs',
    '//package/widgets/C582C3F92001B1E424327F69C7D765092D90A05C98274B26/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.RandomName-Basic', {
    }, {
        prefs: {
            groupUUID: {
                type: 'hidden', // This preference does not show up in the panel, but allows us to save a variable, in this case the Group UUID  
                defaultValue: '',
                label: 'Group UUID'
            },
            groupName: {
                type: 'hidden', // We include the Group name so that we can present the saved group to the person editing the widget, without having to search again
                defaultValue: '',
                label: 'Group Name'
            },
            title: {
                type: 'text',
                defaultValue: 'Random Name',
                label: 'Title'
            },
            bgcolour: {
                type: 'colourpicker',
                label: 'Pick a background colour',
                defaultValue: '#0017b9',
                accordion: 'Design options'
            },
            fontsize: {
                type: 'number',
                label: 'Font size',
                defaultValue: 24,
                showUnits: 'px',
                accordion: 'Design options'
            },
            textcolour: {
                type: 'colourpicker',
                label: 'Text colour',
                defaultValue: '#FFFFFF',
                accordion: 'Design options'
            }
        },


        packageID: 'C582C3F92001B1E424327F69C7D765092D90A05C98274B26',
        membersArray: [], // We create the array here, so that it can be viewed by mutliple functions
        pick_number: 0,
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */ 
        'widget.live': function(el, ev, data) { // The widget on the page, not in edit mode 
            /* this.element refers to the widget. */
            this.element.html( 
                this.view('main.ejs') // Load in main.ejs as the layout 
            );
            var self = this, // this allows us to avoid binding events etc... */
                warn = self.element.find('.warning'), // Find the DIVs with class '.warning' 
                info = self.element.find('.info'), // as above, but for the info DIV 
                name_display = self.element.find('.name_display'),
                name_box = self.element.find('.name_box'),
                pick_button = self.element.find('.pick_button'),
                spin_button = self.element.find('.spin_button');
            
            name_display.text(self.prefs.title.value); // Use the preferences to set the look of the widget 
            name_box.css('background',self.prefs.bgcolour.value);
            name_box.css('font-size',self.prefs.fontsize.value+'px');
            name_box.css('color',self.prefs.textcolour.value);
                
            if (!self.prefs.groupUUID.value) { // If a group UUID is not set, prompt the user by leaving the warning visible and hide the buttons 
                pick_button.hide();
                spin_button.hide();
            } else {
                warn.hide(); // Hide the warning message DIV if a group is set 
                pick_button.hide(); // Hide the pick button as the widget is not currently cycling through names 

                Frog.Model.api('groups.getMembers', { // Use Frog's API to look for all members in a group with the matching UUID 
                    uuid: self.prefs.groupUUID.value,
                    ignore_profiles: 'true'
                }).done(function(memberResponse) { // memberResponse is all the information returned from the API

                    var members = memberResponse.data; // We are only interested in the data part of the response 

                    // To see all the data returned for each member with this API, uncomment the next line:
                    // console.log(members);
                    // This will show you the attributes such as username, display name etc... 

                    $.each(members, function(index,member) { // use $.each to loop for every entry within members
                        self.membersArray.push(member.forename+' '+member.surname); // Add each member to the array
                    });
                    self.shuffle(self.membersArray); // Shuffle the array to randomise it
                });
            }
        },
        shuffle: function(array) { // Shuffle the array
             var currentIndex = array.length,  randomIndex;
             // While there remain elements to shuffle...
             while (0 !== currentIndex) {
                 // Pick a remaining element...
                 randomIndex = Math.floor(Math.random() * currentIndex);
                 currentIndex--;
                 // And swap it with the current element.
                 [array[currentIndex], array[randomIndex]] = [array[randomIndex], array[currentIndex]];
             }
             return array;
        },

        '.spin_button click': function () {
            var self = this,
                name_display = self.element.find('.name_display'),
                pick_button = self.element.find('.pick_button'),
                spin_button = self.element.find('.spin_button'),
                i = 0;

            pick_button.show(); // Show the pick button and hide the start button 
            spin_button.hide();
            self.spinInterval = setInterval(function() {
                name_display.text(self.membersArray[i]); // Display each name in turn in the widget, this is just for decoration.  The Pick button chooses independently
                i++;
                if (i > self.membersArray.length-1) {
                    i = 0;
                }   
            }, 60);
        },
        '.pick_button click': function () {
            var name_display = this.element.find('.name_display'),
                pick_button = this.element.find('.pick_button'),
                spin_button = this.element.find('.spin_button');

            window.clearInterval(this.spinInterval);
            name_display.text(this.membersArray[this.pick_number]);
            this.pick_number++; // With the array shuffled, each name is picked in order. so that everyone only gets picked once.  you could shuffle the array each time instead and always pick the first entry.  Which would remove the need for pick_number.
            
            spin_button.show();
            pick_button.hide();
            if (this.pick_number > this.membersArray.length-1) { // Once the last name is picked, reshuffle the array
               this.pick_number = 0;
               this.shuffle(this.membersArray);
            }
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) { // The widget in edit mode 
            this.element.html(
                this.view('./widget.ejs') // Load in the layout to be displayed during editing 
            );
            window.clearInterval(this.spinInterval); // if the widget is spinning through names when you click Edit, stop it here.
            
            var self = this,
                warn = this.element.find('.warning'),
                info = this.element.find('.info');

            steal.import('frogui/modules/selectusers/selectusers!frog-component').then(function() { // We can import Frog's Group selector component so that we don't have to write our own.  In this widget, the group is picked in Edit mode, but you could move this component to Live mode and pick the group when viewing.
                var groupName = self.element.find("div.group-select input.groupName"),
                    groupSelect = self.element.find("div.group-select");

                groupSelect.frogui_modules_selectusers({
                    show_label: true,
                    label: self._('preference.button_label'), // Set the label's title in lang.manifest.json
                    show_permission: false,
                    show_submit: true,
                    submit_label: self._('preference.button_submit_label'), // This button sends the selected group to the next function
                    allow_convert: false,
                    search_users: false,
                    max_selections: 1,
                    profiles: ['admin','staff','parent','governor','student','external admin','external staff'] // Determine which profile types are searchable with the group selector
                });
            });
            
            warn.hide();
            if (self.prefs.groupUUID.value != '') { // If a group is set already and the page is being edited, display the name here
                info.append(self.prefs.groupName.value);
            }
        },

        'selectusers.submitted': function() { // This function runs when the submit button (part of the Frog component) is clicked
            var self = this,
                groupSelect = self.element.find("div.group-select");
            
            groupSelect.trigger('selectusers.getSelected', function(data) {
                if (!data.groups.length) {
                    return;
                }
                var selectedGroup = data.groups[0].uuid,
                    selectedGroupName = data.groups[0].name,
                    info = self.element.find('.info');
                
                info.show();
                self.prefs.groupUUID.value = selectedGroup; // Set the groupUUID preference to the selected group 
                self.prefs.groupName.value = selectedGroupName;  // Set the groupName preference to the selected group 
                info.append(data.groups[0].name);
            });
        },
      
        'widget.updated': function(el, ev, data) {}
    });
});

