Com.Frog.Utils.require(
    '//package/widgets/206FF80F2001BB898458AF7E84FEAE0773CEB07C5EF7F135/assets/styles/main.css',
    '//package/widgets/206FF80F2001BB898458AF7E84FEAE0773CEB07C5EF7F135/assets/views/main.ejs',
    '//package/widgets/206FF80F2001BB898458AF7E84FEAE0773CEB07C5EF7F135/widget.ejs',
    '//package/widgets/206FF80F2001BB898458AF7E84FEAE0773CEB07C5EF7F135/assets/models/keyword_action_model.js'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.KeywordandEmail', {
    }, {
        prefs: {
            label: {
              type: 'text',
              defaultValue: 'Add keyword',
              label: 'Button label'
            },
            confirmation: {
                type: 'boolean',
                defaultValue: false,
                label: 'Require confirmation',
                accordion: 'Set Keyword options'
            },
            message: {
              type: 'text',
              defaultValue: 'Do you want to set this keyword for this site?',
              label: 'Confirmation message',
              accordion: 'Set Keyword options'
            },
            wordsToSet: {
                type: 'sitetags',
                label: 'Add keywords',
                defaultValue: '',
                show_categories: false,
                accordion: 'Set Keyword options'
            },
            wordsToUnset: {
                type: 'sitetags',
                label: 'Remove keywords',
                defaultValue: '',
                show_categories: false,
                accordion: 'Set Keyword options'
            },
            buttoncolour: {
                type: 'radio',
                label: 'Button Colour',
                options: {
                    'Blue': 'btn-primary',
                    'Green': 'btn-success',
                    'Amber': 'btn-warning',
                    'Red': 'btn-danger',
                    'Grey': '',
                },
                defaultValue: 'btn-primary',
                accordion: 'Design options'
            },
            emailaddresses: {
                type: 'textarea',
                label: 'Add email addresses here (comma separated)',
                placeholder: 'e.g. admin@school.com,office@school.com',
                defaultValue: '',
                accordion: 'Email options'
            },
            emailSubject: {
                type: 'Text',
                label: 'Email Subject',
                defaultValue: 'Keyword set',
                accordion: 'Email options'
            },
            emailMessage: {
                type: 'textarea',
                label: 'Email message',
                defaultValue: 'Someone has pressed Set keyword',
                accordion: 'Email options'
            },
            userWhoPushed: {
                type: 'boolean',
                label: "Include user's name in email subject",    
                defaultValue: 'true',
                accordion: 'Email options'
            },

        },

        packageID: '206FF80F2001BB898458AF7E84FEAE0773CEB07C5EF7F135',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.render();
        },
        setKeywords: function() { /* Mainly copied from set keyword widget */
            var toSet = '',
                toUnset = '';

            if (this.prefs.wordsToSet.value) {
                toSet = JSON.parse(
                    this.prefs.wordsToSet.value
                ).keywords;
            }
            if (this.prefs.wordsToUnset.value) {
                toUnset = JSON.parse(
                    this.prefs.wordsToUnset.value
                ).keywords;
            }
            if (toSet == '' && toUnset == '') {
                this.showGrowl('fail','No keywords set');
            } else {
                Widget.Models.KeywordAction.getKeywordsForSite({
                    link_uuid: this.element.closest('.sites-site-content').data('siteUuid')
                }).done(function(keywords) {
                    var existingKeywords = Object.keys(keywords);
                    $.each(toSet, function (idx, keyword) {
                        if (existingKeywords.indexOf(keyword) === -1) {
                             existingKeywords.push(keyword);
                        }
                    });
                    $.each(toUnset, function (idx, keyword) {
                        var idx = existingKeywords.indexOf(keyword);
                        if (idx != -1) {
                            existingKeywords.splice(idx, 1);
                        }
                    });

                    Widget.Models.KeywordAction.setKeywords({
                        identity: this.element.closest('.sites-site-content').data('siteUuid'),
                        keywords: existingKeywords.toString(),
                        respect_creator: false
                    }).done(function() {
                        this.element.trigger('site.updated');
                        this.updateEditorKeywords(existingKeywords);
                    }.bind(this));

                }.bind(this));
            };
        },

        updateEditorKeywords: function(keywords) {
            var keyword_map = keywords.map(function(key) {
                    return {
                        name: key
                    };
                }),
                editor = this.element.closest('.sites-site-container').siblings('.sites_editor'),
                tags_pref = editor.length ? editor.find('.sites-editor-prefs-tags .frogui_modules_sitetags') : null,
                controller = tags_pref ? tags_pref.controller() : null;

            if (controller) {
                controller.update({
                    keywords: keyword_map
                });
            }
            this.sendEmail();
            /* Reloads the site */
            this.element.closest('div.app-sites').find('div.sites-site-container').first().trigger('reloadSite');
        },
 
        '.keyword-action:not(.disabled) click': function () {
            var self = this
            if (this.prefs.confirmation.value) {
               this.confirm(
                this._(can.esc(this.prefs.message.value)),
                null, {
                    buttons: [{
                        label: can.esc(this.prefs.label.value),
                        klass: 'btn-success',
                        action: self.setKeywords.bind(self)
                    }, {
                        label: this._('Cancel')
                    }],
                    title: this._('Are you sure?')
                });
            } else {
                this.setKeywords();
            }
        },
        
        
        sendEmail: function() {
            var user = FrogOS ? FrogOS.getUser() : this.getUser(),
                to = this.prefs.emailaddresses.value,
                subject = this.prefs.emailSubject.value,
                siteUrl = Frog.Utilities.getBaseUrl()+'/'+this.options.externalUrl;
            
            if (this.prefs.emailaddresses.value != '') {
                if (user.email != '') { // Does Frog have the logged in users's email address? If so, send them a copy of the email
                    to = to+','+user.email;
                }
                if (this.prefs.userWhoPushed.value === true) { 
                    subject = this.prefs.emailSubject.value+' - '+user.displayname
                }
                FrogOS.fdp({
                    url: 'email/sendmessage',
                    path: '/api/fdp/1/',
                    type: 'POST',
                    data: { 
                        subject: subject,
                        message: '<b>'+user.displayname+'</b><br> '+this.prefs.emailMessage.value+'<br><br><br><b>Direct link:</b> '+siteUrl+'<br><br><br>', // Styling html for email is tricky, the multiple <BR>s create space in the message
                        to: to,
                        cc: '',
                        bcc: '',
                        send_individual_messages: true
                    }
                }).done(function(response) {
                    this.showGrowl('success','Email sent successfully');
                     // Email sent
                }.bind(this)).fail(function(e) {
                    // Cannot send email
                    this.showGrowl('fail','Cannot send email');
                });
            } //end of email address check 
            else {
                // No email address
                this.showGrowl('fail','No email address specified');
            }
        },
        showGrowl: function(status,reason) {
            var time = 5000;
            if (status == 'success') {
                time = 2000;
            };
            Frog.Controller.prototype.growl(reason,'Keyword and Email','app-name',{time:time, icon: 'externalapps/icon/206FF80F2001BB898458AF7E84FEAE0773CEB07C5EF7F135'});
        },

        'widget.edit': function(el, ev, data) {
            this.render();
            this.element.find('.keyword-action').addClass('disabled');
        },
        'widget.save': function(el, ev, data) {
            var button =  this.element.find('.keyword-action');
            button.removeClass('btn-primary btn-success btn-warning btn-danger');
            button.text(this.prefs.label.value).addClass(this.prefs.buttoncolour.value);
            this.element.find('.keyword-action').addClass('disabled');
        },
        render: function() {
            this.element.html(
                this.view('main.ejs')
            );
            var button =  this.element.find('.keyword-action');
            button.removeClass('btn-primary btn-success btn-warning btn-danger');
            button.text(this.prefs.label.value).addClass(this.prefs.buttoncolour.value);
        },

        'widget.updated': function(el, ev, data) {}
    });
});
