Com.Frog.Utils.require(
    '//package/widgets/9F74AE632001B96430C60F4880549D00D7A11B1C63A38BCA/assets/styles/main.css',
    '//package/widgets/9F74AE632001B96430C60F4880549D00D7A11B1C63A38BCA/assets/views/main.ejs',
    '//package/widgets/9F74AE632001B96430C60F4880549D00D7A11B1C63A38BCA/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.SetMyPreferences', {
    }, {
        prefs: {
            hide: {
                type: 'boolean',
                label: 'Hide Notifications from My Preferences',
                defaultValue: false,
                accordion: 'Advanced'
            },
            alias: {
                type: 'text',
                label: 'Data Reference - change this to overwrite any existing user settings',
                defaultValue: 'MyPrefs',
                accordion: 'Advanced'
            },
            assignment: {
                type: 'radio',
                label: "Assignments",
                vertical: true,
                options: {
                    'None': '{ "name": "assignment", "alert": "false", "email": "false" }',
                    'Frog notification': '{ "name": "assignment", "alert": "true", "email": "false" }',
                    'Email': '{ "name": "assignment", "alert": "false", "email": "true" }',
                    'Both': '{ "name": "assignment", "alert": "true", "email": "true" }',
                },
                defaultValue: '{ "name": "assignment", "alert": "false", "email": "false" }',
                publish: []
            },
            calendar: {
                type: 'radio',
                label: "Calendar",
                vertical: true,
                options: {
                    'None': '{ "name": "calendar", "alert": "false", "email": "false" }',
                    'Frog notification': '{ "name": "calendar", "alert": "true", "email": "false" }',
                    'Email': '{ "name": "calendar", "alert": "false", "email": "true" }',
                    'Both': '{ "name": "calendar", "alert": "true", "email": "true" }',
                },
                defaultValue: '{ "name": "calendar", "alert": "false", "email": "false" }',
                publish: []
            },
            feedback: {
                type: 'radio',
                label: "Feedback",
                vertical: true,
                options: {
                    'None': '{ "name": "feedback", "alert": "false", "email": "false" }',
                    'Frog notification': '{ "name": "feedback", "alert": "true", "email": "false" }',
                    'Email': '{ "name": "feedback", "alert": "false", "email": "true" }',
                    'Both': '{ "name": "feedback", "alert": "true", "email": "true" }',
                },
                defaultValue: '{ "name": "feedback", "alert": "false", "email": "false" }',
                publish: []
            },
            form: {
                type: 'radio',
                label: "Form",
                vertical: true,
                options: {
                    'None': '{ "name": "form", "alert": "false", "email": "false" }',
                    'Frog notification': '{ "name": "form", "alert": "true", "email": "false" }',
                    'Email': '{ "name": "form", "alert": "false", "email": "true" }',
                    'Both': '{ "name": "form", "alert": "true", "email": "true" }',
                },
                defaultValue: '{ "name": "form", "alert": "false", "email": "false" }',
                publish: []
            },
            forum: {
                type: 'radio',
                label: "Forum",
                vertical: true,
                options: {
                    'None': '{ "name": "forum", "alert": "false", "email": "false" }',
                    'Frog notification': '{ "name": "forum", "alert": "true", "email": "false" }',
                    'Email': '{ "name": "forum", "alert": "false", "email": "true" }',
                    'Both': '{ "name": "forum", "alert": "true", "email": "true" }',
                },
                defaultValue: '{ "name": "forum", "alert": "false", "email": "false" }',
                publish: []
            },
            frogos: {
                type: 'radio',
                label: "Frog Update",
                vertical: true,
                options: {
                    'None': '{ "name": "frogos", "alert": "false", "email": "false" }',
                    'Frog notification': '{ "name": "frogos", "alert": "true", "email": "false" }',
                    'Email': '{ "name": "frogos", "alert": "false", "email": "true" }',
                    'Both': '{ "name": "frogos", "alert": "true", "email": "true" }',
                },
                defaultValue: '{ "name": "frogos", "alert": "false", "email": "false" }',
                publish: []
            },
            generic: {
                type: 'radio',
                label: "Generic",
                vertical: true,
                options: {
                    'None': '{ "name": "generic", "alert": "false", "email": "false" }',
                    'Frog notification': '{ "name": "generic", "alert": "true", "email": "false" }',
                    'Email': '{ "name": "generic", "alert": "false", "email": "true" }',
                    'Both': '{ "name": "generic", "alert": "true", "email": "true" }',
                },
                defaultValue: '{ "name": "generic", "alert": "false", "email": "false" }',
                publish: []
            },
            like: {
                type: 'radio',
                label: "Like Added",
                vertical: true,
                options: {
                    'None': '{ "name": "like", "alert": "false", "email": "false" }',
                    'Frog notification': '{ "name": "like", "alert": "true", "email": "false" }',
                    'Email': '{ "name": "like", "alert": "false", "email": "true" }',
                    'Both': '{ "name": "like", "alert": "true", "email": "true" }',
                },
                defaultValue: '{ "name": "like", "alert": "false", "email": "false" }',
                publish: []
            },
            mis: {
                type: 'radio',
                label: "MIS",
                vertical: true,
                options: {
                    'None': '{ "name": "mis", "alert": "false", "email": "false" }',
                    'Frog notification': '{ "name": "mis", "alert": "true", "email": "false" }',
                    'Email': '{ "name": "mis", "alert": "false", "email": "true" }',
                    'Both': '{ "name": "mis", "alert": "true", "email": "true" }',
                },
                defaultValue: '{ "name": "mis", "alert": "false", "email": "false" }',
                publish: []
            },
            mychildswork: {
                type: 'radio',
                label: "My Child's Work",
                vertical: true,
                options: {
                    'None': '{ "name": "mychildswork", "alert": "false", "email": "false" }',
                    'Frog notification': '{ "name": "mychildswork", "alert": "true", "email": "false" }',
                    'Email': '{ "name": "mychildswork", "alert": "false", "email": "true" }',
                    'Both': '{ "name": "mychildswork", "alert": "true", "email": "true" }',
                },
                defaultValue: '{ "name": "mychildswork", "alert": "false", "email": "false" }',
                publish: []
            },
            preferences: {
                type: 'radio',
                label: "My Preferences",
                vertical: true,
                options: {
                    'None': '{ "name": "preferences", "alert": "false", "email": "false" }',
                    'Frog notification': '{ "name": "preferences", "alert": "true", "email": "false" }',
                    'Email': '{ "name": "preferences", "alert": "false", "email": "true" }',
                    'Both': '{ "name": "preferences", "alert": "true", "email": "true" }',
                },
                defaultValue: '{ "name": "preferences", "alert": "false", "email": "false" }',
                publish: []
            },
            notice: {
                type: 'radio',
                label: "Noticeboard",
                vertical: true,
                options: {
                    'None': '{ "name": "notice", "alert": "false", "email": "false" }',
                    'Frog notification': '{ "name": "notice", "alert": "true", "email": "false" }',
                    'Email': '{ "name": "notice", "alert": "false", "email": "true" }',
                    'Both': '{ "name": "notice", "alert": "true", "email": "true" }',
                },
                defaultValue: '{ "name": "notice", "alert": "false", "email": "false" }',
                publish: []
            },
            poll: {
                type: 'radio',
                label: "Poll",
                vertical: true,
                options: {
                    'None': '{ "name": "survey", "alert": "false", "email": "false" }',
                    'Frog notification': '{ "name": "survey", "alert": "true", "email": "false" }',
                    'Email': '{ "name": "survey", "alert": "false", "email": "true" }',
                    'Both': '{ "name": "survey", "alert": "true", "email": "true" }',
                },
                defaultValue: '{ "name": "survey", "alert": "false", "email": "false" }',
                publish: []
            },
            quicklaunchlink: {
                type: 'radio',
                label: "Quick Launch",
                vertical: true,
                options: {
                    'None': '{ "name": "quicklaunchlink", "alert": "false", "email": "false" }',
                    'Frog notification': '{ "name": "quicklaunchlink", "alert": "true", "email": "false" }',
                    'Email': '{ "name": "quicklaunchlink", "alert": "false", "email": "true" }',
                    'Both': '{ "name": "quicklaunchlink", "alert": "true", "email": "true" }',
                },
                defaultValue: '{ "name": "quicklaunchlink", "alert": "false", "email": "false" }',
                publish: []
            },
            share: {
                type: 'radio',
                label: "Share",
                vertical: true,
                options: {
                    'None': '{ "name": "share", "alert": "false", "email": "false" }',
                    'Frog notification': '{ "name": "share", "alert": "true", "email": "false" }',
                    'Email': '{ "name": "share", "alert": "false", "email": "true" }',
                    'Both': '{ "name": "share", "alert": "true", "email": "true" }',
                },
                defaultValue: '{ "name": "share", "alert": "false", "email": "false" }',
                publish: []
            },
            timelines: {
                type: 'radio',
                label: "Timelines",
                vertical: true,
                options: {
                    'None': '{ "name": "event", "alert": "false", "email": "false" }',
                    'Frog notification': '{ "name": "event", "alert": "true", "email": "false" }',
                    'Email': '{ "name": "event", "alert": "false", "email": "true" }',
                    'Both': '{ "name": "event", "alert": "true", "email": "true" }',
                },
                defaultValue: '{ "name": "event", "alert": "false", "email": "false" }',
                publish: []
            },
            wall: {
                type: 'radio',
                label: "Wall",
                vertical: true,
                options: {
                    'None': '{ "name": "wall", "alert": "false", "email": "false" }',
                    'Frog notification': '{ "name": "wall", "alert": "true", "email": "false" }',
                    'Email': '{ "name": "wall", "alert": "false", "email": "true" }',
                    'Both': '{ "name": "wall", "alert": "true", "email": "true" }',
                },
                defaultValue: '{ "name": "wall", "alert": "false", "email": "false" }',
                publish: []
            },
            eportfolio: {
                type: 'radio',
                label: "ePortfolio",
                vertical: true,
                options: {
                    'None': '{ "name": "eportfolio", "alert": "false", "email": "false" }',
                    'Frog notification': '{ "name": "eportfolio", "alert": "true", "email": "false" }',
                    'Email': '{ "name": "eportfolio", "alert": "false", "email": "true" }',
                    'Both': '{ "name": "eportfolio", "alert": "true", "email": "true" }',
                },
                defaultValue: '{ "name": "eportfolio", "alert": "false", "email": "false" }',
                publish: []
            }
        },

        packageID: '9F74AE632001B96430C60F4880549D00D7A11B1C63A38BCA',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            if (this.prefs.hide.value === true) { // uses CSS to hide the notifications optin in My prefs
                this.element.find('.hide').append(
                    '<style>'+
                    '.app-preferences a[data-action="user.notifications"] { display: none !important; }'+
                    '</style>'
                );
            }

            FrogOS.fdp({
                url: 'datastore/get',
                path: '/api/fdp/2/',
                type: 'GET',
                data: {
                    target_uuid: this.options.uuid,
                    alias: this.prefs.alias.value,
                    user_uuid: FrogOS.getUser().uuid
                }
            }).done(function(response) {
                if (response.response.length) {
                    // If there exists an entry, do nothing, user prefs have already been set
                } else {
                    // If there is no entry set prefs, then add to datastore
                    var user = FrogOS ? FrogOS.getUser() : this.getUser(),
                        cats = []; 
                    cats.push(JSON.parse('{ "name": "workspace", "alert": "true" }'));
                    cats.push(JSON.parse(this.prefs.calendar.value));
                    cats.push(JSON.parse('{ "name": "site", "alert": "true" }'));
                    cats.push(JSON.parse(this.prefs.assignment.value));
                    cats.push(JSON.parse('{ "name": "trump", "alert": "true" }'));
                    cats.push(JSON.parse(this.prefs.frogos.value));
                    cats.push(JSON.parse(this.prefs.mis.value));
                    cats.push(JSON.parse('{ "name": "award", "alert": "true" }'));
                    cats.push(JSON.parse('{ "name": "course", "alert": "true" }'));
                    cats.push(JSON.parse(this.prefs.quicklaunchlink.value));
                    cats.push(JSON.parse(this.prefs.mychildswork.value));
                    cats.push(JSON.parse('{ "name": "achieve", "alert": "true" }'));
                    cats.push(JSON.parse('{ "name": "academy", "alert": "true" }'));
                    cats.push(JSON.parse(this.prefs.timelines.value));
                    cats.push(JSON.parse(this.prefs.like.value));
                    cats.push(JSON.parse(this.prefs.share.value));
                    cats.push(JSON.parse(this.prefs.preferences.value));
                    cats.push(JSON.parse(this.prefs.eportfolio.value));
                    cats.push(JSON.parse(this.prefs.feedback.value));
                    cats.push(JSON.parse(this.prefs.wall.value));
                    cats.push(JSON.parse(this.prefs.forum.value));
                    cats.push(JSON.parse(this.prefs.form.value));
                    cats.push(JSON.parse(this.prefs.poll.value));
                    cats.push(JSON.parse(this.prefs.generic.value));
                    cats.push(JSON.parse('{ "name": "transfertool", "alert": "true" }'));
                    cats.push(JSON.parse(this.prefs.notice.value));
         
                    Frog.Model.api('notifications.setChannels', {
                        availableDrivers: ["alert", "email"],
                        categories: cats,
                        email: user.email
                    },{type: "POST"}).done(function(response) {
                        FrogOS.fdp({
                            url: 'datastore/create',
                            path: '/api/fdp/2/',
                            type: 'POST',
                            data: {
                                target_uuid: this.options.uuid,
                                data: 'prefSet',
                                alias: this.prefs.alias.value,
                                user_uuid: FrogOS.getUser().uuid
                            }
                        }).done(function(response) {
                            // Do things
                        }.bind(this)).fail(function(e) {
                            // Report Error
                        }.bind(this)); /* End of datastore create */ 

                    }.bind(this)).fail(function(e) {
                    // Report Error
                    }.bind(this)); /* End of set prefs API */
                }
            }.bind(this))
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        },

        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {}
    });
});
