Com.Frog.Utils.require(
    '//package/widgets/101D53622001B89AA74C0F059D9D8503824A599CDFFDC9C8/assets/styles/main.css',
    '//package/widgets/101D53622001B89AA74C0F059D9D8503824A599CDFFDC9C8/assets/views/main.ejs',
    '//package/widgets/101D53622001B89AA74C0F059D9D8503824A599CDFFDC9C8/assets/views/row.ejs',
    '//package/widgets/101D53622001B89AA74C0F059D9D8503824A599CDFFDC9C8/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.SiteSearch', {
    }, {
        prefs: {},
        editing: false,
        packageID: '101D53622001B89AA74C0F059D9D8503824A599CDFFDC9C8',

        init: function() {},

        'widget.live': function(el, ev, data) {
            this.editing = false;
            this.element.html(
                this.view('main.ejs')
            );
        },
        'widget.edit': function(el, ev, data) {
            this.editing = true;
            this.element.html(
                this.view('./widget.ejs')
            );
        },
        'widget.updated': function(el, ev, data) {},

        removeLayoutHtml: function(html) {
            var temporalDivElement = document.createElement("div");
            temporalDivElement.innerHTML = html;
            return temporalDivElement.textContent || temporalDivElement.innerText || "";
        },    

        showRow: function(pageName, pageLink, resultContents, index, type) {
            var self = this,
                searchResult = self.element.find('.siteSearchResult'),
                searchInput = self.element.find('.siteSearchTerm').val(),
                textSummary = '';
                        
            self.element.find('.alert-info').hide();
            if (type == 'Text') {
                var charIndex = parseInt(index),
                    subString = 0,
                    ellipsis = '';
                if (charIndex >= 25) {
                    subString = charIndex-10;
                    ellipsis = '... ';
                }
                resultContents = ellipsis+resultContents.substring(subString, subString+200);  
            } // end of IF type == 'Text'

            searchResult.append(
                self.view(
                    'row.ejs', {
                        pageLink: pageLink,
                        pageName: pageName,
                        resultContents: resultContents,
                        type: type
                    }
                ) // end of self.view
            ); // end of append
        }, // End of showRow function 

        searchSitePage: function(pageName, pageLink, pageUUID, show_by_default, show_in_navigation) {
            var self = this,
                searchInput = self.element.find('.siteSearchTerm').val();
            
            // Search text and link to file widgets
            if (show_by_default === true && show_in_navigation === true) {               
                // Search & list page titles
                if (pageName.toString().toLowerCase().indexOf(searchInput.toLowerCase()) > -1) {
                    self.showRow(pageName, pageLink, '', 0, 'page');
                }
                Frog.Model.api('pages.getContent', {
                    page: pageLink,
                    page_uuid: pageUUID
                }).done(function(pageResponse) {
                    var buckets = pageResponse.data.buckets;
                    $.each(buckets, function(index,bucket) {
                        $.each(bucket, function(index,widget) {
                            var textSummary = '';
                            if (widget.widget.name == 'Text') {
                                textSummary = self.removeLayoutHtml(widget.prefs.user_input);
                                
                            } else if (widget.widget.name == 'Link to File') { 
                                textSummary = $.EJS.clean(widget.prefs.resource_name);
                                
                            } else if (widget.widget.name == 'External Link') { 
                                textSummary = $.EJS.clean(widget.prefs.site_name)+': '+$.EJS.clean(widget.prefs.site_description);
                                
                            }
                            var index = textSummary.toString().toLowerCase().indexOf(searchInput.toLowerCase());
                            if (index > -1) {
                                self.showRow(pageName, pageLink, textSummary, index, widget.widget.name);
                            }
                        });   
                    });
                    
                }).fail(function(e) {
                    Frog.Controller.prototype.growl('Failed to load pages','Site Search','app-name',{time:5000, icon: 'externalapps/icon/'+self.packageID});
                });             
            }
        }, // end of SearchPage function

        '.siteSearchBtn click': function (event,target) {
            
            var self = this,
                searchResult = self.element.find('.siteSearchResult'),
                searchInput = self.element.find('.siteSearchTerm').val();
            searchResult.empty();
   
            if (self.editing === false) {
                self.element.find('.alert-success').show(); // Searching
                self.element.find('.alert-info').hide(); // no results found
                self.element.find('.alert-danger').hide(); // short search string
                if (searchInput.length > 2) {          
                    var siteLink = this.options.siteLink;

                    Frog.Model.api('pages.getNavigation', {
                        site: siteLink
                     }).done(function(siteResponse) {
                         var pagesT1 = siteResponse.data.children;
                         self.element.find('.alert-success').hide(); // API call completed, hide the "Searching text"
                         self.element.find('.alert-info').show();
                         $.each(pagesT1, function(index,pageT1) {      
                             self.searchSitePage(pageT1.node.name, pageT1.node.link, pageT1.node.uuid, pageT1.node.show_by_default, pageT1.node.show_in_navigation);                      
                             if (pageT1.children) {
                                 var pagesT2 = pageT1.children;
                                 $.each(pagesT2, function(index2,pageT2) {
                                     self.searchSitePage(pageT2.node.name, pageT2.node.link, pageT2.node.uuid, pageT2.node.show_by_default, pageT2.node.show_in_navigation);                   
                                     if (pageT2.children) {
                                         var pagesT3 = pageT2.children;
                                         $.each(pagesT3, function(index3,pageT3) {
                                             self.searchSitePage(pageT3.node.name, pageT3.node.link, pageT3.node.uuid, pageT3.node.show_by_default, pageT3.node.show_in_navigation);        
                                         }); // end of tier 3 $.each
                                     } // end of tier 2 IF children check
                                 }); // end of tier 2 $.each
                             }; // end of tier 1 IF children check
                         }); // end of tier 1 $.each               
                    }).fail(function(e) {
                        Frog.Controller.prototype.growl('Failed to search','Site Search','app-name',{time:5000, icon: 'externalapps/icon/101D53622001B89AA74C0F059D9D8503824A599CDFFDC9C8'});
                    });
                } else { // end of IF character length check
                    self.element.find('.alert-danger').show();
                    self.element.find('.alert-info').hide();
                    self.element.find('.alert-success').hide();
                }  
            } // end of edit mode check     
        } // end of searchBtn function      

    });
});
