Com.Frog.Utils.require(
    '//package/widgets/7575CCD62001B79508406FB9816B2B065A32877C6DE81B03/assets/styles/main.css',
    '//package/widgets/7575CCD62001B79508406FB9816B2B065A32877C6DE81B03/assets/views/main.ejs',
    '//package/widgets/7575CCD62001B79508406FB9816B2B065A32877C6DE81B03/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.SiteSharingStatus', {
    }, {
        prefs: {
      'nosites': {
                type: 'number',
                label: 'Number of sites to search for (larger numbers will take longer)',
                defaultValue: 500
            }
        },

        packageID: '7575CCD62001B79508406FB9816B2B065A32877C6DE81B03',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            var self = this;
            this.element.html(
                this.view('main.ejs')
            ); 
            var siteList = this.element.find('.siteList');

            Frog.Model
                    .api('sites.search', {
                        include_associations: true,
                        limit: this.prefs.nosites.value,
                        offset: '0',
                    order: {
                            updated:"desc"
                        },
                    query: "%",
                        exclude_sources: {
                            0:"temporary",
                            1:"my_dashboard"
                        },
                    scope: "global"

                }).done(function(listResponse) {
                  var sites = listResponse.data.sites;
                
                  $.each(sites, function(index,site) {
                        if (site.type!=="dashboard") { /* Ignore if site is a dashboard */
                        if (site.share_data) {
                            Frog.Model.api('share.getList', {
                                target:site.uuid
                            }).done(function(shareReponse) {
                            var $siteStatus;
                            $siteStatus="";
                                if(shareReponse.data.group) {
                                var groups = shareReponse.data.group;
                                $.each(groups, function(index,group) {
                                    siteList.append(
                                      self.view('row.ejs',{sitename: site.name, sitelink: site.link, displayname: group.identity.name, access: group.permission, uuid: site.uuid, author: site.author.username})
                                    );
                                });
                                }
                                
                                if(shareReponse.data.user) {
                                var users = shareReponse.data.user;
                                $.each(users, function(index,user) {
                                  siteList.append(
                                      self.view('row.ejs',{sitename: site.name, sitelink: site.link, displayname: user.identity.displayname, access: user.permission, uuid: site.uuid, author: site.author.username})
                                  );
                                });   
                                }
                            });
                        } else {
                            siteList.append(
                                self.view('row.ejs',{sitename: site.name, sitelink: site.link, displayname: 'Private', access: '', uuid: site.uuid, author: site.author.username})
                            );                         
                        }
                        } /* End of dashboard check*/
                    });
            });
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        },

        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {}
    });
});
