Com.Frog.Utils.require(
    '//package/widgets/1F0D78132001BA1AF85FEFFA6F35240BB3A79EDCBA0A976C/assets/styles/main.css',
    '//package/widgets/1F0D78132001BA1AF85FEFFA6F35240BB3A79EDCBA0A976C/assets/views/main.ejs',
    '//package/widgets/1F0D78132001BA1AF85FEFFA6F35240BB3A79EDCBA0A976C/assets/views/child.ejs',
    '//package/widgets/1F0D78132001BA1AF85FEFFA6F35240BB3A79EDCBA0A976C/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.StaffParentChildSelector', {
    }, {
        prefs: {
            'associations': {
                'type': 'associations',
                'label': 'Widget Collections',
                'defaultValue': JSON.stringify({
                    'associations': [],
                    'publisher': true,
                    'subscriber': false
                })
            },
           'title': {
                type: "text",
                defaultValue: "Click to select child",
               label: "Title"
            }
        },


        packageID: '1F0D78132001BA1AF85FEFFA6F35240BB3A79EDCBA0A976C',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        render: function(){
            Frog.Model.api('users.getChildren').done(function(response){
                var child;
                for(var i = 0; i < response.data.length; i++) {
                    child = Lib.Models.User.model(response.data[i]);
                    this.element.append(
                        this.view('child.ejs', {user: child})
                    );
                    if (i===0) {
                        this.element.find('.child').addClass("childselected");
                        this.doBroadcast(child);
                    }
                }
                
                Frog.Utilities.hookupModels(this.element);
                
            }.bind(this));
        },

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            this.render();
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        },

        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {},
        
        '[data-action="select-child"] click': function(el, ev){
            var model = el.model();
            this.doBroadcast(model);
            this.element.find('.child').removeClass("childselected");
            el.addClass("childselected");
        },
        
        doBroadcast: function(user) {
            var controller = new Frog.Widget.Controller(this.element, {}, {prefs: this.prefs});
            controller.broadcast('selectedUser', new Broadcast.Models.User(user.serialize()));
        }
    });
});

