Com.Frog.Utils.require(
    '//package/widgets/6DDB2F312001B542BBB45FE3AA9E2709E25C5FBC10A9C3EA/assets/styles/main.css',
    '//package/widgets/6DDB2F312001B542BBB45FE3AA9E2709E25C5FBC10A9C3EA/assets/views/main.ejs',
    '//package/widgets/6DDB2F312001B542BBB45FE3AA9E2709E25C5FBC10A9C3EA/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.EasyGateway', {
    }, {
        prefs: {
            "title":{
                "type":"text",
                "label":"Title",
                "defaultValue":"Staff Remote Access"
            },
            
            "desc":{
                "type":"textarea",
                "label":"Description",
                "defaultValue":"Remote Access is a feature in frog that allows you to access your School PC from home as if you where sitting right in front of it.<b/>Access to the Secure Gateway can be requested from the ICT team.<b/>You can use Remote Access on a Windows PC/Laptop by clicking 'Establish Connection' on the left, wiat a few seconds for the download to begin and simply run the downloaded file."
            },
            
            "norules":{
                "type":"textarea",
                "label":"No rule's explanation",
                "defaultValue":"Unfortunatly it does not appear that you have been set up to use Remote Access.</b>Speak with your school IT administrators if you belive this is in error."
            },
            
            "filename":{
                "type":"text",
                "label":"Filename of download",
                "defaultValue":"Gateway"
            },
            
            "ip":{
                "type":"text",
                "label":"Gateway IP",
                "defaultValue":"0.0.0.0"
            },
            
            "port":{
                "type":"text",
                "label":"Gateway Port",
                "defaultValue":"2001"
            },
            
            "domain":{
                "type":"text",
                "label":"Logon domain",
                "defaultValue":""
            },
            
            "redirectclipboard":{
                "type":"boolean",
                "label":"Redirect Clipboard",
                "defaultValue":"true"
            },
        },

        packageID: '6DDB2F312001B542BBB45FE3AA9E2709E25C5FBC10A9C3EA',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {
            this.element.html(
                this.view('main.ejs')
            );
        },

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.updateRules();

            this.element.html(
                this.view('main.ejs')
            );
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        },

        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {
            this.updateRules();

            this.element.html(
                this.view('main.ejs')
            );
        },

        /**
         * Update the rules list.
         */
         'updateRules': function() {
            this.gatewayRules = {};
            
            var widget = this;
            var request = Lib.Models.SecureGateway.Rule.findAllForCurrentUser();

            request.done(function() {
                var responseData = JSON.parse(request.responseText);

                if (responseData !== null) {
                    widget.gatewayRules = responseData.response.rules;

                    widget.element.html(
                        widget.view('rules.ejs')
                    );

                    widget.populateMenu();
                } else {
                    widget.element.html(
                        widget.view('norules.ejs')
                    );
                }
            });

            request.fail( function() {
                widget.element.html(
                    widget.view('norules.ejs')
                );
            });
         },

         /**
         * Add the rules to the gateway list.
         */

        'populateMenu': function() {
            var widget = this;
            var menu = document.getElementById("Widget.EasyGateway.Select");

            if (this.gatewayRules) {
                var rules = [];
                
                for (var k in this.gatewayRules) {
                    var gatewayRule = this.gatewayRules[k];
                    var desc = gatewayRule.description.toUpperCase();
                    
                    var id = 99;
                    var matched = desc.match(/^\([0-9]+\)/g);
                                               
                    if (matched !== null && matched.length == 1) {
                        var match = matched[0];
                        desc = gatewayRule.description.substr(match.length, desc.length);
                        id = parseInt( match.substr(1, match.length - 2));
                    } else if (desc == FrogOS.getUser().displayname.toUpperCase() || desc == FrogOS.getUser().username.toUpperCase()){
                        id = 0;
                        desc = gatewayRule.description;
                    } else {
                        desc = gatewayRule.description;
                    }
                    
                    rules.push({id:gatewayRule.uuid, desc:desc, i:id});
                }
                
                rules.sort( function(a, b){
                    return a.id < b.id;
                });
                
                for (var j in rules) {
                    var ruleInfo = rules[j];
                    
                    var opt = document.createElement('option');
                    
                    opt.innerHTML = ruleInfo.desc;
                    
                    opt.value = ruleInfo.id;
                    
                    menu.appendChild(opt);
                }
            }

            var btn = document.getElementById("Widget.EasyGateway.Download");

            btn.onclick = function() {
                widget.setActiveRule(menu.options[menu.selectedIndex]);
            };
        },

        /**
         * Add the rules to the gateway list.
         */

        'setActiveRule': function(option) {
            var widget = this;
            
            if (option) {
                Lib.Models.SecureGateway.Rule.api(
                {
                    url: "securegateway/enableruleforcurrentuser",
                    data: {
                        uuid: option.value
                    },
                    type: "POST",
                    dataType: "json rule",
                    converters: {
                        "json rule":function(a)
                        {
                            widget.downloadBlobFile();
                        }
                    }
                });
            }
        },

        /**
         * Generate the blob file.
         */

        'downloadBlobFile': function() {
            var content = "";
            var ip = this.prefs.ip.value;
            var port = this.prefs.port.value;
            var domain = this.prefs.domain.value;
            var fileName = this.prefs.filename.value;
			
            content += "full address:s:" + ip;

            if (port && port !== ""){
                content += ":" + port;
            }

            content += "\n";

            if (domain && domain !== "")
                content += "domain:s:" + domain + "\n";
            
            if (this.prefs.redirectclipboard.value)
                content += "redirectclipboard:i:1\n";
            
            content += "username:s:" + FrogOS.getUser().username + "\n";
            
            var blob = new Blob([content], { type:"text/plain" });
            
            if (!fileName || fileName === "") {
                fileName = "gateway";
            }

            if (window.navigator.msSaveOrOpenBlob) {
                window.navigator.msSaveBlob(blob, this.prefs.filename.value + ".rdp");
            } else {
                var element = window.document.createElement('a');
                
                element.href = window.URL.createObjectURL(blob);
                
                element.download = this.prefs.filename.value + ".rdp";
                
                document.body.appendChild(element);
                
                element.click();
                
                document.body.removeChild(element);
            }
        }
    });
});
