Com.Frog.Utils.require(
    '//package/widgets/AE1D6B532001B40FF431FF578ACAEC0D3990BD2C579A5A24/assets/styles/main.css',
    '//package/widgets/AE1D6B532001B40FF431FF578ACAEC0D3990BD2C579A5A24/assets/views/main.ejs',
    '//package/widgets/AE1D6B532001B40FF431FF578ACAEC0D3990BD2C579A5A24/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.StyleControl', {
    }, {
        prefs: {
            fontsize: {
                type: "number",
                label: "Default font size for text widgets, noticeboards etc...",
                defaultValue: 14,
                showUnits: "pt"
          },
          linkcolour: {
                type: 'colourpicker',
                label: 'Choose a default colour for hyperlinks',
                defaultValue: '#0071b9'
          },
          widgetcolour: {
                type: 'colourpicker',
                label: 'Choose a colour for widgets',
                defaultValue: ''
          },
          globalcss: {
                type: 'boolean',
                label: 'Apply to all sites - if checked, the styling you choose will apply to any site opened',
                defaultValue: false,
                accordion: 'Advanced'
          },
          h6banner: {
                type: 'boolean',
                label: 'Create a banner using H6 within the text widget',
                defaultValue: true,
                accordion: 'Banner'
          },
          h6bannerback: {
                type: 'colourpicker',
                label: 'H6 banner background',
                defaultValue: '#0071b9',
                accordion: 'Banner'
          },
          h6bannerfontcolor: {
                type: 'colourpicker',
                label: 'H6 Text colour',
                defaultValue: '#FFFFFF',
                accordion: 'Banner'
          },
          h6bannerfontsize: {
                type: "number",
                label: "H6 banner font-size",
                defaultValue: 20,
                showUnits: "pt",
                accordion: 'Banner'         
          }
        },

        packageID: 'AE1D6B532001B40FF431FF578ACAEC0D3990BD2C579A5A24',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            this.addCSS();
        },
        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.renderInEdit();
        },
        'widget.save': function(el, ev, data) {
            this.renderInEdit();
        },
        renderInEdit : function() {
            this.element.html(
                this.view('./widget.ejs')
            );
            this.addCSS();
        },
        addCSS : function() {
            var siteUUIDdiv = 'div[data-site-uuid="'+this.options.site_uuid+'"] ',
                lineheight = parseInt(this.prefs.fontsize.value, 10)+5,
                h6banner = '',
                widgetcolor = '';
            if (this.prefs.globalcss.value == true) {
                siteUUIDdiv = '';
            };
            if (this.prefs.h6banner.value == true) {
                h6banner = siteUUIDdiv+'.widget_text h6 { font-size: '+this.prefs.h6bannerfontsize.value+'pt !important; color: '+this.prefs.h6bannerfontcolor.value+' !important; background: '+this.prefs.h6bannerback.value+' !important; padding-left:10px !important; padding-top:13px !important; height:38px !important; margin-top:0px !important;'
            };
         
            if (this.prefs.widgetcolour.value !== '' && this.prefs.widgetcolour.value !== '#ffffff') {
                widgetcolor = siteUUIDdiv+'.widget_filedrop .head-out .theme-headerbg, '+siteUUIDdiv+'.widget_filelink a {'+'background: '+this.prefs.widgetcolour.value+' !important;'+'}'
            };
            this.element.find('.CSS').html(
                '<style>'+
                siteUUIDdiv+'.widget_text, '+siteUUIDdiv+'.widget_text p,  '+siteUUIDdiv+'.wall_widget .body, '+siteUUIDdiv+'.wall_widget .post_wall, '+siteUUIDdiv+'.widget_forum .content, '+siteUUIDdiv+'.notice-content, '+siteUUIDdiv+'.notice-content li, '+siteUUIDdiv+'.notice-title, '+siteUUIDdiv+'.cke_editable_inline p, '+siteUUIDdiv+'.widget_text li {'+
                     'font-size: '+this.prefs.fontsize.value+'px !important;'+
                     'line-height: '+lineheight+'px !important;'+
                '}'+
                siteUUIDdiv+'.widget_text a, '+siteUUIDdiv+'.widget_text p a {'+
                    'color: '+this.prefs.linkcolour.value+' !important;'+
                '}'+
                 widgetcolor+
                 h6banner+
                '</style>'
            );
        }
    });
});
