Com.Frog.Utils.require(
    '//package/widgets/FF92B5692001B85ABA506FF7161E4E06E06C769CDEF946A4/assets/styles/main.css',
    '//package/widgets/FF92B5692001B85ABA506FF7161E4E06E06C769CDEF946A4/assets/views/main.ejs',
    '//package/widgets/FF92B5692001B85ABA506FF7161E4E06E06C769CDEF946A4/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.Twitter', {
    }, {
        prefs: {
            twitterName: {
                type: 'text',
                label: 'Twitter Name',
                placeholder: "@frogeducation",
                defaultValue: '@frogeducation'
            },
            height: {
                type: 'number',
                label: 'Height',
                defaultValue: 400,
                showUnits: "pixels",
                min: 200,
                accordion: 'settings.advanced'
            },
            twitterEmbed: {
                type: 'text',
                label: 'Timeline Embed code from Twitter',
                placeholder: "<a class...",
                defaultValue: '',
                accordion: 'settings.advanced'
            },
        },

        packageID: 'FF92B5692001B85ABA506FF7161E4E06E06C769CDEF946A4',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            if (this.prefs.twitterEmbed.value==="") {
                this.element.html(
                    this.view('main.ejs')
                );
            } else {
                this.element.html(
                    this.view('embed.ejs')
                );
                var twitArray = this.prefs.twitterEmbed.value.split('href="https://twitter.com/'),
                    twitSubArray = "",
                    twitNameArray2 = "",
                    twitName = "";
                	/* Added this step to prevent widget crashing if the correct embed code is not used. */ 
                	if (twitArray[1]) {
                        twitSubArray = twitArray[1].split('"');
                        twitNameArray2 = twitArray[1].split('Tweets by ');
                        twitName = twitNameArray2[1].split('</a>');
                    }
                this.element.find('.embed').append(
                   '<a class="twitter-timeline" data-height="'+ this.prefs.height.value +'" href="https://twitter.com/'+twitSubArray[0]+'">Tweets by '+ twitName[0] +'</a>'+
                   '<script>if (typeof twttr != "undefined") twttr.widgets.load();</script>'
                );
            }
        },
        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
            this.renderInEdit();
        },

        'widget.save': function(el, ev, data) {
            this.renderInEdit();
        },
         renderInEdit : function() {
			this.find('.widget-content').css('height',this.prefs.height.value+'px');
        },

        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {

        }
    });
});
