Com.Frog.Utils.require(
    '//package/widgets/6658A37B2001BAD0B3AECF2FD5F713024E643C9C6A8D7911/assets/styles/main.css',
    '//package/widgets/6658A37B2001BAD0B3AECF2FD5F713024E643C9C6A8D7911/assets/views/main.ejs',
    '//package/widgets/6658A37B2001BAD0B3AECF2FD5F713024E643C9C6A8D7911/assets/views/player.ejs',
    '//package/widgets/6658A37B2001BAD0B3AECF2FD5F713024E643C9C6A8D7911/assets/views/videoItem.ejs',   
    '//package/widgets/6658A37B2001BAD0B3AECF2FD5F713024E643C9C6A8D7911/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.VideoPlaylist', {
    }, {
        prefs: {
            shared_folder: {
                type: 'sharedfolder',
                defaultValue: '|'
            },
            height: {
                type: 'number',
                label: 'Height of video',
                defaultValue: 400,
                showUnits: 'px',
            },
            fontsize: {
                type: 'number',
                label: 'Text size',
                defaultValue: 14,
                showUnits: 'pt',
            },
            colour: {
                type: 'colourpicker',
                label: 'Text colour',
                defaultValue: '#0071b9'
            }
        },

        packageID: '6658A37B2001BAD0B3AECF2FD5F713024E643C9C6A8D7911',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {

            var folderID = this.prefs.shared_folder.value.split("|"),
                folderList,
                player;
            
            this.element.removeAttr('style');
            
            this.renderPlaceholder();
            
            folderList = this.element.find('.list');
            folderList.html(' ');
            if (this.prefs.shared_folder.value==="|") {
            	folderList.append('<b>No folder specified</b>');
            }
            player = this.element.find('.player');
       
            Frog.Model
                .api('resources.getOfType', {
                    sources: ["native","site"],
                    type: 'staff',
                    author: 'true',
                    root_folder: 'EDAAA0E92002F81B92C2DFCD917CAC05E532634CEE5FEBD9',
                    folder: folderID[0],
                    filter: null,
                    exclude_templates: 'true'
                }).done(function(listResponse) {
                    //console.log(listResponse.data.resources);
                    var files = listResponse.data.resources,
                        int=0;
                  
                    $.each(files, function(index,file) {

                        if (file.attachment.file.mime.ext==="mp4"){
                            folderList
                            .append(
                               this.view('videoItem.ejs',{name:file.attachment.name,src:file.external_url})
                            );
                            /* Add the first video in the list to the player */
                            if (int<1){
                                this.element.find('.playerspace').html(this.view('player.ejs',{src:file.external_url,height:this.prefs.height.value}));
                                this.element.find('.player').removeAttr("autoplay");
                            }
                            int++;
                        } // end of if mp4
                    }.bind(this)); /* end of $.each */
                    $('.videoitem').click(function(ev) {
                        this.element.find('.playerspace').html(this.view('player.ejs',{src:$(ev.target).data('src'),height:this.prefs.height.value}));
                    }.bind(this));
            }.bind(this));
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.renderPlaceholder();
        },
        'widget.save': function(el, ev, data) {      
            this.renderPlaceholder();
            
        },
        renderPlaceholder : function() {
            this.element.html(
                this.view('main.ejs')
            );
            var folderList = this.element.find('.list');

            folderList.append(this.view('videoItem.ejs',{name:'Example Video 1',src:''}));
            folderList.append(this.view('videoItem.ejs',{name:'Example Video 2',src:''}));
            folderList.append(this.view('videoItem.ejs',{name:'Example Video 3',src:''}));
            folderList.css('color',this.prefs.colour.value);
            folderList.css('font-size',this.prefs.fontsize.value+'pt');

            this.element.find('.playerspace').css('height',this.prefs.height.value+"px");
        }
    });
});