Com.Frog.Utils.require(
    '//package/widgets/A89B9C412001B746334FCF7441700C0A4C4C438C90923D01/assets/styles/main.css',
    '//package/widgets/A89B9C412001B746334FCF7441700C0A4C4C438C90923D01/assets/views/main.ejs',
    '//package/widgets/A89B9C412001B746334FCF7441700C0A4C4C438C90923D01/assets/views/row.ejs',
    '//package/widgets/A89B9C412001B746334FCF7441700C0A4C4C438C90923D01/assets/views/blank.ejs',
    '//package/widgets/A89B9C412001B746334FCF7441700C0A4C4C438C90923D01/assets/clipboard.js',
    '//package/widgets/A89B9C412001B746334FCF7441700C0A4C4C438C90923D01/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.VisitorLog', {
    }, {
        prefs: {
            "dateorder": {
                type: 'radio',
                label: "Date order",
                vertical: true,
                options: {
                     'DD/MM/YY': 'uk',
                     'MM/DD/YY': 'us'
                },
                defaultValue: "uk",
                publish: []
            },
            dataref: {
                type: 'text',
                label: 'Data reference (change this to reset log)',
                defaultValue: 'visitor_log'
            }
        },
        users: [],
        visit_data: [],
        
        packageID: 'A89B9C412001B746334FCF7441700C0A4C4C438C90923D01',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            FrogOS.fdp({
                url: 'datastore/get',
                path: '/api/fdp/2/',
                type: 'GET',
                data: {
                    target_uuid: this.options.site_uuid,
                    alias: this.prefs.dataref.value,
                    user_uuid: FrogOS.getUser().uuid
                }
            }).done(function(response) {
                var visit_data,
                    is_update = false;
    
                if (response.response.length) {
                    visit_data = JSON.parse(response.response[0].data);
                    is_update = response.response[0].uuid;
                } else {
                    visit_data = {
                        user_uuid: FrogOS.getUser().uuid,
                        visits: []
                    }
                }
                this.logVisit(visit_data, is_update);
                 
            }.bind(this)).fail(function(e) {
                // Report Error
                console.log("failed");
            });
            
            if (this.options.sitePermission === 'admin') {
                this.renderStats();
            } else {
                this.element.html(
                    this.view('blank.ejs')
                );
            }
        },
        
        logVisit: function(visit_data, is_update)
        {
            visit_data.visits.push(moment().unix());
            visit_data = JSON.stringify(visit_data);
            var method = 'datastore/create',
                data = {
                    target_uuid: this.options.site_uuid,
                    data: visit_data,
                    alias: this.prefs.dataref.value,
                    user_uuid: FrogOS.getUser().uuid
                };

            if (is_update) {
                method = 'datastore/update';
                data.uuid = is_update
            }
            
            FrogOS.fdp({
                url: method,
                path: '/api/fdp/2/',
                type: 'POST',
                data: data
            }).done(function(response) {
                // Do things
                //console.log("done");
            }).fail(function(e) {
                // Report Error
                console.log("failed");
            });
        },
        
        renderStats: function() {
            this.element.html(
                this.view('main.ejs')
            );
            this.element.find('.sitestats').hide();
            this.element.find('.copyTableButton').hide();
        },
        
        '[data-action="get-stats"] click': function(el, ev) {
            this.visit_data = {};
            this.total_visit_count = 0;
            this.element.find('.sitestats').show();
            this.element.find('.copyTableButton').show();
            this.element.find('.table-data').empty();
            this.users = [];

            FrogOS.fdp({
                url: 'datastore/get',
                path: '/api/fdp/2/',
                type: 'GET',
                data: {
                    target_uuid: this.options.site_uuid,
                    alias: this.prefs.dataref.value
                }
            }).done(function(response) {
                var uuids = [],
                    requests = [],
                    tmp = [];

                for (var i = 0; i < response.response.length; i++) {
                  uuids.push(response.response[i].user_uuid);
                  var data = JSON.parse(response.response[i].data);
                  this.visit_data[data.user_uuid] = data.visits;
                  this.total_visit_count += data.visits.length;
                }

               while (uuids.length > 0) {
                   tmp = uuids.splice(0, 50);
                   if (tmp.length > 0) {
                      var req = this.getUsers(tmp);
                       requests.push(req);
                   }
               }

               $.when.apply($, requests).then(function() {

                   this.renderData();
               }.bind(this));
                
            }.bind(this));
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        },

        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {},
        'onlyUnique' : function(value, index, self) { 
            return self.indexOf(value) === index;
        },

         getUsers: function(uuids) {
             var deferred = $.Deferred();

             Frog.Widget.Model.api('users.getSummary', { 'uuid' : uuids }, {
              'type': 'GET',
                'dataType': 'json users',
                'converters': {
                    'json users': function(response) {
                        return response.data;
                    }
                }
            }).done(function(users) {
                 for(var i = 0; i < users.length; i++) {
                     this.users.push(users[i]);
                 }
              deferred.resolve();
            }.bind(this)).error(function(err) {
              deferred.reject();
            }.bind(this));

            return deferred.promise();
      },
        
      renderData: function() {
          var container = this.element.find('.table-data');
          this.element.find('.total_count').html('Total visits to this page: ' +this.total_visit_count);
               //debugger;       
          for (var i = 0; i < this.users.length; i++) {
              var user_total_visit_count = this.visit_data[this.users[i].uuid].length,
                  latest_visit = this.visit_data[this.users[i].uuid].pop(),
                  childnames = "";
              
              var dateorder = moment.unix(latest_visit).format('DD/MM/Y'),
                   yeargroup = '';
              if (this.prefs.dateorder.value === "us") {
                   dateorder = moment.unix(latest_visit).format('MM/DD/Y')
              };
              if (this.users[i].group_types.year) {
                  yeargroup = this.users[i].group_types.year.groups;
              };

              container.append(
                  this.view('row.ejs', {
                      display_name: this.users[i].details.forename+' '+this.users[i].details.surname,
                      table_row: this.users[i].uuid,
                      username: this.users[i].username,
                      yeargroup: yeargroup,
                      profile_type: this.users[i].profile.type,
                      visit_count: user_total_visit_count,
                      date_visit: dateorder,
                      time_visit: moment.unix(latest_visit).format('HH:mm')
                   })
              );

              if (this.users[i].profile.type === "Parent") {
                  var c = i;
                 this.element.find('.profile'+this.users[i].uuid).append(":");
                  var request_data = {
                      url: 'user/getchildren',
                      path: '../api/fdp/2/',
                      dataType: 'json user',
                      converters: {
                          'json user': function(data) {
                              data.response.parent_uuid = data.request.params.body.uuid;
                              return data.response;
                          }.bind(this)
                      },
                      data: {
                          'uuid' : this.users[i].uuid
                      }
                  }

                  Frog.Model.fdpapi(request_data).done(function(listResponse) {
                      var year = "";
                      $.each(listResponse.children, function(index,child) {
                          Frog.Widget.Model.api('users.getDataInCategory', { 
                              uuid: 'CF0040192004C7FA1DC2CF7565EE6B07D0214F9C9F08CD46',
                              user_uuid: child.uuid
                          }).done(function(groups) {
                              $.each(groups.data.groups, function(index,group) {
                                  if (group.type.type == "year") {
                                      year = group.name;
                                  }
                              });
                              this.element.find('.profile'+listResponse.parent_uuid).append("<BR>"+child.displayname+" - "+year);
                          }.bind(this));
                      }.bind(this));  
                  }.bind(this)).error(function(err){
                      //error handling here
                  });

                   }
              } // end of loop
          },
        
          '.copyTableButton click': function() {
              new Clipboard('.copyTableButton');
          },
        
    });
});
