Com.Frog.Utils.require(
    '//package/widgets/A49F09E42001B558453B3F37D4A21B0FC855599C5BAB3E45/assets/styles/main.css',
    '//package/widgets/A49F09E42001B558453B3F37D4A21B0FC855599C5BAB3E45/assets/views/main.ejs',
    '//package/widgets/A49F09E42001B558453B3F37D4A21B0FC855599C5BAB3E45/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.WeekIndicator', {
    }, {
        prefs: {
            "label1": {
                label: "Label for Week 1",
                defaultValue: "Welcome to week 1",
                type: "text"
            },
            "label2": {
                label: "Label for Week 2",
                defaultValue: "This is week 2",
                type: "text"
            },
            "startDate": {
                type: "date",
                label: "Select a date in a timetabled first week.",
                defaultValue: ""
            },
            "fontsize": {
                type: "number",
                defaultValue: 14,
                label: "Font size",
                accordion: 'settings.advanced'
            },
            "fontcolor": {
                type: "colourpicker",
                label: "Font colour",
                defaultValue: "#0071b9",
                accordion: 'settings.advanced'
            },
            "style":{
                type:"text",
                defaultValue:"",
                label:"Widget Stylesheet",
                accordion: 'settings.advanced'
            },
        },

        packageID: 'A49F09E42001B558453B3F37D4A21B0FC855599C5BAB3E45',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.renderPlaceholder();
            var weekLabel = this.element.find('.weekLabel'),
                startDate = moment(this.prefs.startDate.value, "DD/MM/YYYY").weeks(),
                currentDate = moment().weeks(),
                myarray = [this.prefs.label1.value,this.prefs.label2.value],
                dayDifference = this.datereset(currentDate-startDate);
            
            weekLabel.text(myarray[dayDifference]);
        },
        datereset:function(dayDifference){
            while(dayDifference>=2){
                dayDifference=dayDifference-2;
            }         
            return dayDifference;
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.renderPlaceholder();
        },
        'widget.save': function(el, ev, data) {      
            this.renderPlaceholder();
        },
        renderPlaceholder : function() {
            this.element.html(
                this.view('main.ejs')
            );
            this.element.find('.weekLabel').text(this.prefs.label1.value);
            this.element.find('.weekLabel').css('font-size',this.prefs.fontsize.value+'pt');
            this.element.find('.weekLabel').css('line-height',this.prefs.fontsize.value+'pt');
            this.element.find('.weekLabel').css('color',this.prefs.fontcolor.value);
        },

        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {}
    });
});
