Com.Frog.Utils.require(
    '//package/widgets/63CC17E02001B6247F9EBF4452B2D80E50A6362CA3B267A9/assets/styles/main.css',
    '//package/widgets/63CC17E02001B6247F9EBF4452B2D80E50A6362CA3B267A9/assets/views/main.ejs',
    '//package/widgets/63CC17E02001B6247F9EBF4452B2D80E50A6362CA3B267A9/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.WhoAmITeaching', {
    }, {
        prefs: {
             student_group: {
                type: "list",
                label: "Show students that I teach who are also in the following group:",
                defaultValue: "pupil_premium",
                options: {
                    "Pupil Premium": "pupil_premium",
                    "SEN": "sen",
                    "EAL": "eal",
                    "IGT": "is_gifted",
                    "FSM": "fsm",
                    "Services Child": "is_service_child",
                    "Looked After": "in_care"
                }
            },
            ePortCol: {
                type: "text",
                label: "Associate student with a particular ePortfolio collection",
                defaultValue: "3DFA1CAB200C49565E11BF76146F3100AA4F49EC90E3D8FB",
                placeholder: "Add ePortfolio collection uuid here...",
                accordion: 'settings.advanced'
            }
        },

        packageID: '63CC17E02001B6247F9EBF4452B2D80E50A6362CA3B267A9',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            
            var currentuser = FrogOS.getUser();
            var $mypppp = this.element.find(".widget_mypplist");
            var student_flags_uuid = "F3A046342004C31D2202BFC5159509053172444CCD360D5F";
            var ePortfolio = this.prefs.ePortCol.value;
            var group_flag =  this.prefs.student_group.value;
            var myClassArr = [];
            var myStudentArr = [];
            //////////////////////////////////////////////////////////

            var getPPPP = function(anyuuid) {
                Frog.Model
                    .api(
                    'timetables.getTimetable',
                    {
                        limit: 4,
                        offset: 0,
                        week_starts_on: 1,
                        user_uuid: currentuser.uuid,
                        target: [anyuuid]
                    }
                ).done(function(thisResponse) {
                    if (thisResponse.data.length > 0) {
                        var data = thisResponse.data[0];
                        myClassArr = [];
                        $.each(data.weeks, function(i,weeks) {
                            $.each(weeks.days, function(p,days) {
                                $.each(days.periods, function(q,periods) {
                                    try{
                                        var cstyle = getCssOfClass(periods.group.name);
                                        var x = {group: periods.group.name, uuid: periods.group.uuid, style: cstyle};
                                        var result = arrayFind(myClassArr, function(v){
                                            return v.uuid === periods.group.uuid;
                                        });
                                        if (result === -1) {
                                            myClassArr.push(x);
                                        }
                                    } catch(e) {}
                                });
                            });
                        });
                        $.each(myClassArr, function(i, v) {
                            loadclass(v.uuid, v.style);
                        });
                    } else {
                        console.log("No classes found");
                    }
                });
            };
            
            
            var loadclass = function (classid, class_style) {
                Frog.Model.api('groups.getMembers',{ignore_profiles: true, uuid: classid})
                    .done(function(thisResponse) {
                    $.each(thisResponse.data, function(i,member) {
                        if(member.profile.type === 'profile-student') {
                            Frog.Model.api('users.getDataInCategory', { user_uuid: member.uuid, uuid: student_flags_uuid })
                                .done(function(resp) {
                                var fields = resp.data.fields;
                                fields.forEach(function(field) {
                                    if (field.label === group_flag) {
                                        if (field.value === "yes") {
                                            //we've found one
                                            try{
                                                var thumbnail;
                                                if (!member.thumbnail) {
                                                    thumbnail = "users/public/images/default_no_gender.png";                 
                                                } else {
                                                    thumbnail = member.thumbnail;
                                                }
                                                var x = {username: member.username, uuid: member.uuid, displayname: member.displayname, style: class_style, thumb: thumbnail};
                                                var result = arrayFind(myStudentArr, function(v){
                                                    return v.uuid === member.uuid;
                                                });
                                                if (result === -1) {
                                                    myStudentArr.push(x);
                                                    var query = x.username;
                                                    Frog.Model.api('sites.getSitesByAssociation', {view:"eportfolio",type:"recipient_eportfolios",sitegroup_uuid:ePortfolio,scope:"personal",query:query})
                                                    .done(function(thisResponse) {
                                                        var firstsite;
                                                        var link = "";
                                                        var name = "";
                                                        if (!thisResponse.data[0].children.length==0) {
                                                        	firstsite = thisResponse.data[0].children[0];
                                                            link = firstsite.link;
                                                       		name = firstsite.name;
                                                        }
                                                        $mypppp.find(".nokids").hide();
                                                        $mypppp.append('<div data-link="'+link+'" class="tiles_view eport"><div class="column widget-icon-wrapper"><div class="widget-icon" data-toggle="tooltip" title="'+name+'"><div class="img-wrapper" style="background-image: url('+x.thumb+')"></div><div class="os-ellipsis banner '+x.style+'">'+x.displayname+'</div></div></div></div>');
                                                    });
                                                }
                                            } catch(e) {

                                            }  
                                        }
                                    }
                                });
                            });   
                        }
                    });
                    
                });
            };
            
            
            $mypppp.off("click", "div.eport");  
            $mypppp.on("click", "div.eport", function(ev) {
                var link = $(ev.currentTarget).data("link");
                if (link !='') {
                    FrogOS.openSite({
                        site: link,
                    });
                } else {
                    alert("No ePortfolio found for this student");
                }
            });
            
            function getCssOfClass(classname) {
                var id = classname.substr(0, 1);
                if (id==="0") {
                    id = classname.substr(1, 1);
                }
                if (id==="7" || id==="8" || id==="9") {
                    return "ui-"+id;
                } else if (id==="1") {
                    id = classname.substr(0, 2);
                    if (id==="10" || id==="11" || id==="12" || id==="13") {
                        return "ui-"+id;
                    }
                } else {
                    return "ui-x";
                }
            }
            
            function codeToDescription(code) {
                if (code=="pupil_premium") {
					return "Pupil Premium";
                }
                if (code=="sen") {
					return "SEN";
                }
                if (code=="eal") {
					return "EAL";
                }
                if (code=="is_gifted") {
					return "Gifted and Talented";
                }
                if (code=="fsm") {
					return "Free School Meals";
                }
                if (code=="is_service_child") {
					return "Services Children";
                }
                if (code=="in_care") {
					return "Looked After";
                }
            }
            
            function arrayFind(arr, fn) {
                for( var i = 0, len = arr.length; i < len; ++i ) {
                    if( fn(arr[i]) ) {
                        return i;
                    }
                }
                return -1;
            }
            
            $mypppp.append("<h4>This is a list of the students that you teach who are also in the "+ codeToDescription(this.prefs.student_group.value) +" group.</h4>");
            $mypppp.append("<p class='nokids'>No students found.</p>");
            getPPPP();
            
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
        },

        /**
         * Event fired by the Site Controller. Tells the widget that something has been changed during editing.
         *
         * @event 'widget.updated'
         */
        'widget.updated': function(el, ev, data) {}
    });
});
