Com.Frog.Utils.require(
    '//package/widgets/4CB64A082001B6C86A730FA605DDA60813E63A4C9D6A6A5D/assets/styles/main.css',
    '//package/widgets/4CB64A082001B6C86A730FA605DDA60813E63A4C9D6A6A5D/assets/views/main.ejs',
    '//package/widgets/4CB64A082001B6C86A730FA605DDA60813E63A4C9D6A6A5D/assets/views/row.ejs',
    '//package/widgets/4CB64A082001B6C86A730FA605DDA60813E63A4C9D6A6A5D/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.FormRegister', {
    }, {
        prefs: {
            groupType: {
                type: 'radio',
                label: 'Select type of group to list',
                vertical: true,
                options: {
                    'Class': 'class',
                    'Club': 'club',
                    'House': 'house',
                    'Job Role': 'jobrole',
                    'Location': 'location',
                    'Registration': 'registration'
                },
                defaultValue: 'club',
                publish: []
            },
             preselected_form: {
                type: 'PreselectedForm',
                label: 'Registration Form',
                defaultValue: JSON.stringify({"formUuid": "", "userCanOverrideFilters": false})
            },
            showTeacher: {
                type: 'boolean',
                label: 'List Staff and Admins',
                defaultValue: false
            },
            submitLabel: {
                type: 'text',
                label: 'Submit button label',
                defaultValue: 'Submit register',
                accordion: 'Advanced'
            },
            emailAddresses: {
                type: 'textarea',
                label: 'Send email to these addresses on submission (comma separated)',
                placeholder: 'e.g. admin@school.com,office@school.com',
                defaultValue: '',
                accordion: 'Email options'
            },
            emailSubject: {
                type: 'Text',
                label: 'Email Subject',
                defaultValue: 'Groups Register',
                accordion: 'Email options'
            },        
            UserPickerField: {
                type: 'hidden',
                label: 'User Field UUID',
                defaultValue: ''
            },
            GroupNameField: {
                type: 'hidden',
                label: 'Group Name Field UUID',
                defaultValue: ''
            },
            AttendanceField: {
                type: 'hidden',
                label: 'Attendance Field UUID',
                defaultValue: ''
            },
        },
        groupName: '',

        packageID: '4CB64A082001B6C86A730FA605DDA60813E63A4C9D6A6A5D',

        init: function() {},

        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            this.getAllGroups();
            var formUUID = JSON.parse(this.prefs.preselected_form.value).formUuid;
            if (formUUID !== 'default' && formUUID !== '') {   
                this.element.find('.warning').hide();
            } else {
                this.element.find('.groups_list').attr('disabled', 'disabled');
            }
        },
        getAllGroups : function() {
            var self = this;
            var dropdown = self.element.find('.groups_list');
            
            Frog.Model.api('groups.getGroupList', {
                type: self.prefs.groupType.value,
                unlinked_external: true
            }).done(function(response) {
                var groups = response.data;
                $.each(groups,function(index,group) {
                    dropdown.append( 
                        $('<option />').attr('value', group.uuid).text(group.name) 
                    )               
                });
                dropdown.prepend(
                    $('<option />').text(self._('widget.placeholder.select')).prop('selected', true)
                );
                self.element.find('.submit_register').hide();
            }).fail(function(e) {
                self.showGrowl('Failed to find groups');
            });
        },
        
        '.groups_list change': function () {
            var self = this;
            var group = self.element.find('.groups_list :selected').val();
            
            var table = self.element.find('.member_list');
            table.find( 'tr:not(:first)' ).remove();
            
            if (group !== '') {
                self.groupName = self.element.find('.groups_list').find('option:selected').text();
                Frog.Model.api('groups.getMembers', {
                    uuid: group,
                    ignore_profiles: true
                }).done(function(response) {
                    var members = response.data;
                    var profilesAdult = ['profile-staff','profile-admin','profile-governor'];
                    $.each(members, function(index,member) {
                        if ((profilesAdult.includes(member.profile.type) === true && self.prefs.showTeacher.value) || member.profile.type == 'profile-student') {
                            table.append(
                                self.view('row.ejs', {
                                    uuid: member.uuid,
                                    name: member.displayname,
                                    username: member.username
                                })
                            );
                        }
                    });
                    self.element.find('.submit_register').show();
                    
                }).fail(function(e) {
                    self.showGrowl('Failed to find group members');
                });
            }
        },
        '.submit_register click': function () {
            var self = this;
            var formUUID = JSON.parse(self.prefs.preselected_form.value).formUuid;
            var table = self.element.find('.member_list');
            
            var groupMembers = [];
            var groupLength = table.find('.member_row').length;

            $.each(table.find('.member_row'), function (index, row) {
                var uuid = row.dataset.uuid;
                var name = row.dataset.name;
                var attendance =  table.find('.reg_'+uuid+':checked').val();
                
                groupMembers.push({
                    name: name, 
                    attendance: attendance
                });

                if (uuid && formUUID !== 'default' && formUUID !== '') {    
                    Frog.Model.api('form.submission', {
                        notify_creator: '0',
                        site_uuid: self.options.site_uuid,
                        uuid: formUUID,
                        email_user: false,
                        fields: [
                            {
                                form_uuid: formUUID,
                                uuid: self.prefs.GroupNameField.value,
                                type: 'text',
                                label: 'Group Name',
                                value: self.groupName
                            },
                            {
                                form_uuid: formUUID,
                                uuid: self.prefs.UserPickerField.value,
                                type: 'userselect',
                                label: 'Member',
                                email_to_selected_user: 'false',
                                value: uuid
                            },
                            {
                                form_uuid: formUUID,
                                uuid: self.prefs.AttendanceField.value,
                                type: 'radio',
                                label: 'Attendance',
                                value: [attendance]
                            }
                        ]
                    },{
                        type: 'POST'
                    }).done(function(resp) {
                        if (index == groupLength-1) {
                            self.showGrowl('Register taken');
                            if (self.prefs.emailAddresses.value !== '') {
                                self.sendEmail(groupMembers);   
                            }
                        }

                    }).fail(function(e) {
                        self.showGrowl('Failed to write to Form');
                    });
                } else {
                    self.showGrowl('User details not present');
                }
            });
        },

        showGrowl: function(string) {
            var icon = 'externalapps/icon/'+this.packageID;
            Frog.Controller.prototype.growl(string,'Form Register','app-name',{time:'5000', icon: icon});
        },
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('./widget.ejs')
            );
            var formUUID = JSON.parse(this.prefs.preselected_form.value).formUuid;
            if (formUUID !== 'default' && formUUID !== '') {   
                this.element.find('.warning').hide();
            }
        },
        
        'widget.save': function(el, ev, data) {
            var self = this;
            var formUUID = JSON.parse(self.prefs.preselected_form.value).formUuid;
            
            if (formUUID !== 'default' && formUUID !== '') {   
                self.element.find('.warning').hide();
                Frog.Model.api('form.get', {
                    uuid: formUUID,
                    limit: 1,
                    summary: true
                }).done(function(response) {
                    var formStructure = response.data;
                    if (formStructure.fields[0].type === 'text' && formStructure.fields[1].type === 'userselect' && formStructure.fields[2].type === 'radio') {
                        self.prefs.GroupNameField.value = formStructure.fields[0].uuid;
                        self.prefs.UserPickerField.value = formStructure.fields[1].uuid;
                        self.prefs.AttendanceField.value = formStructure.fields[2].uuid;
                    } else {
                        self.showGrowl('Form fields do not match requirements');
                        self.prefs.preselected_form.value = JSON.stringify({'formUuid': '', 'userCanOverrideFilters': false});
                    }
                }).fail(function(e) {
                    self.showGrowl('Failed to get Form');
                });
            }
        },
        
        sendEmail: function(groupMembers) {
            var self = this;
            var user = FrogOS ? FrogOS.getUser() : self.getUser();
            var to = self.prefs.emailAddresses.value;
            if (user.email !== '') {
                    to = to+','+user.email;
            }
            
            var message = '<b>'+self._('widget.placeholder.regEmail')+self.groupName+'</b><br>';
            for (var i = 0; i < groupMembers.length; i++) {
                message += $('<li />').text(groupMembers[i].name+' - '+groupMembers[i].attendance)[0].outerHTML;
            }
            
            FrogOS.fdp({
                url: 'email/sendmessage',
                path: '/api/fdp/1/',
                type: 'POST',
                data: { 
                    subject: self.prefs.emailSubject.value,
                    message: message,
                    to: to,
                    cc: '',
                    bcc: '',
                    send_individual_messages: false
                }
            }).done(function(response) {
                self.showGrowl('Registration Email Sent');
            }).fail(function(e) {
                self.showGrowl('Registration Email Failed to send');
            });  
        },
        
        'widget.updated': function(el, ev, data) {}
    });
});
