Com.Frog.Utils.require(
    '//package/widgets/DFDA91AC2001BDBB6D6DBFD195C6DC083A6A0F9C0E8AF967/assets/styles/main.css',
    '//package/widgets/DFDA91AC2001BDBB6D6DBFD195C6DC083A6A0F9C0E8AF967/assets/views/main.ejs',
    '//package/widgets/DFDA91AC2001BDBB6D6DBFD195C6DC083A6A0F9C0E8AF967/widget.ejs'
).then(function() {
    Com.Frog.Controllers.Widget.extend('Widget.LinktoPageLozenge', {
    }, {
        prefs: {
            page: {
                 type: "pagepicker",
                 label: "Link to a page",
                 defaultValue: JSON.stringify({
                     page_uuid:'',
                     site_uuid:''
                 }),
                 showCurrentSiteOnly: true
             },
             pagedesc: {
                type: 'text',
                label: 'Page Description',
                defaultValue: 'Page link'
             },
             image: {
                type: 'upload',
                label: 'Icon (will be used even if a page icon exists unless left blank)',
                showDiscover: true,
                showClipboard: true,
                filter: ['image'],
                view: 'mini',
                sources: ['native'],
                defaultValue: ''
            }
        },

        packageID: 'DFDA91AC2001BDBB6D6DBFD195C6DC083A6A0F9C0E8AF967',
        /**
         * Constructor. Runs when the widget is first loaded.
         *
         * @method init
         */
        init: function() {},

        /**
         * Event fired by the Site Controller.
         *
         * @event 'widget.live'
         */
        'widget.live': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            this.renderInEdit('live');
        },

        /**
         * Event fired by the Site Controller. Tells the widget that the site is in Edit Mode.
         *
         * @event 'widget.edit'
         */
        'widget.edit': function(el, ev, data) {
            this.element.html(
                this.view('main.ejs')
            );
            this.renderInEdit('edit');
        },
        'widget.save': function(el, ev, data) {
            this.renderInEdit('edit');
        },
         renderInEdit : function(mode) {
            if (this.prefs.page.value != '{"page_uuid":"","site_uuid":""}') {
                var page_opts = JSON.parse(this.prefs.page.value);

                Frog.Model.api('pages.getNavigation', {
                    site: page_opts.site_uuid
                }).done(function(res) {

                    var page_opts = JSON.parse(this.prefs.page.value),
                        pages = res.data.children,
                        find = function(pages, page_uuid){ // 3 tier of navigation to wade through to return correct page data, based on page uuid
                            var pageData = [],
                                link = '',
                                name = '',
                                page_icon = '';
                            $.each(pages, function(k1, d1) {
                                if (link === '' && d1.node.uuid === page_uuid) {
                                    link = d1.node.link;
                                    name = d1.node.name;
                                    page_icon = d1.node.page_icon;
                                };
                                if (d1.hasOwnProperty("children")) {
                                    $.each(d1.children, function(k2, d2) {
                                        if (link === '' && d2.node.uuid === page_uuid) {
                                            link = d2.node.link;
                                            name = d2.node.name;

                                            page_icon = d2.node.page_icon;
                                        };
                                         //console.log(d2);
                                        if (d2.hasOwnProperty("children")) {
                                            $.each(d2.children, function(k3, d3) {
                                                if (link === '' && d3.node.uuid === page_uuid) {
                                                    link = d3.node.link;
                                                    name = d3.node.name;
                                                    page_icon = d3.node.page_icon;
                                                }
                                                //console.log(d3);
                                            }) // end of tier 3 each
                                        }
                                    }) // end of tier 2 each
                                }
                            }) // end of tier 1 each
                            pageData[0] = link;
                            pageData[1] = name;
                            pageData[2] = page_icon;
                            return pageData;
                        };
                    var pageData = find(res.data.children, page_opts.page_uuid);
                    if (mode == 'live') {
                        this.element.find('.buttonlink').attr('data-page-link-cke', pageData[0]);
                        this.element.find('.buttonlink').attr('alt', pageData[0]);
                    }
                    this.element.find('.pagename').text(pageData[1]);
                    this.element.find('.pagedesc').text(this.prefs.pagedesc.value);
                    if (this.prefs.image.value == '') {
                        if (pageData[2] != null) {
                            this.element.find('.pageicon').attr('src',pageData[2]);
                        }
                    } else {
                        this.element.find('.pageicon').attr('src',this.prefs.image.value);
                    }
                }.bind(this));
            }
            if (mode == 'edit') {
                this.element.find('.buttonlink').attr('data-page-link-cke', '');
                clearInterval(this.intervalId);
            }
        },

        'widget.updated': function(el, ev, data) {}
    });
});
